<?php
/**
 * CartFlows Admin Menu.
 *
 * @package CartFlows
 */

namespace CartflowsProAdmin\AdminCore\Inc;

/**
 * Class Admin_Menu.
 */
class AdminMenu {

	/**
	 * Instance
	 *
	 * @access private
	 * @var object Class object.
	 * @since 1.0.0
	 */
	private static $instance;

	/**
	 * Initiator
	 *
	 * @since 1.0.0
	 * @return object initialized object of class.
	 */
	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Instance
	 *
	 * @access private
	 * @var string Class object.
	 * @since 1.0.0
	 */
	private $menu_slug;

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 */
	public function __construct() {
		$this->menu_slug = 'cartflowws';

		$this->initialize_hooks();
	}

	/**
	 * Init Hooks.
	 *
	 * @since 1.0.0
	 * @return void
	 */
	public function initialize_hooks() {

	}


	/**
	 *  Initialize after Cartflows pro get loaded.
	 */
	public function settings_admin_scripts() {
		// Enqueue admin scripts.
		if (isset($_GET['page']) && ('cartflowws' === $_GET['page'] || false !== strpos($_GET['page'], 'cartflowws_'))) { //phpcs:ignore

			add_action( 'admin_enqueue_scripts', array( $this, 'styles_scripts' ) );
		}
	}



	/**
	 * Enqueues the needed CSS/JS for the builder's admin settings page.
	 *
	 * @since 1.0.0
	 */
	public function styles_scripts() {

		$admin_slug = 'cartflows-admin';

		// Styles.
		wp_enqueue_style( $admin_slug . '-common', CARTFLOWS_ADMIN_CORE_URL . 'assets/css/common.css', array(), CARTFLOWS_VER );
		wp_enqueue_style( $admin_slug . '-header', CARTFLOWS_ADMIN_CORE_URL . 'assets/css/header.css', array(), CARTFLOWS_VER );

		$localize = apply_filters(
			'cartflows_react_admin_localize',
			array(
				'cf_pro_status'                   => $this->get_plugin_status( 'cartflows-pro/cartflows-pro.php' ),
				'default_page_builder'            => \Cartflows_Helper::get_common_setting( 'default_page_builder' ),
				'required_plugins'                => \Cartflows_Helper::get_plugins_groupby_page_builders(),
				'is_any_required_plugins_missing' => \Cartflows_Helper::get_any_required_plugins_status(),
				'admin_base_url'                  => admin_url(),
				'admin_url'                       => admin_url( 'admin.php' ),
				'ajax_url'                        => admin_url( 'admin-ajax.php' ),
				'home_slug'                       => $this->menu_slug,
				'is_pro'                          => _is_cartflows_pro(),
				'page_builder'                    => \Cartflows_Helper::get_common_setting( 'default_page_builder' ),
				'global_checkout'                 => \Cartflows_Helper::get_common_setting( 'global_checkout' ),
			)
		);

		if ( $this->is_current_page( $this->menu_slug ) ) {
			$this->settings_app_scripts( $localize );
		} elseif ( $this->is_current_page( 'cartflowws', 'wcf-edit-flow' ) || $this->is_current_page( 'cartflowws', 'wcf-edit-step' ) ) {
			$this->editor_app_scripts( $localize );
		}
	}



}

AdminMenu::get_instance();
