<?php
/**
 * Modules Loader
 *
 * @package CartFlows
 */

/**
 * Initial Setup
 *
 * @since 1.0.0
 */
class Cartflows_Pro_Legacy_Modules_Meta {


	/**
	 * Member Variable
	 *
	 * @var object instance
	 */
	private static $instance;

	/**
	 *  Initiator
	 */
	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor function that initializes required actions and hooks
	 */
	public function __construct() {

		if ( wcf_pro()->is_woo_active ) {
			require_once CARTFLOWS_PRO_LEGACY_ADMIN_DIR . 'modules/checkout/class-cartflows-pro-checkout-meta.php';
			require_once CARTFLOWS_PRO_LEGACY_ADMIN_DIR . 'modules/offer/class-cartflows-pro-base-offer-meta.php';
			require_once CARTFLOWS_PRO_LEGACY_ADMIN_DIR . 'modules/optin/class-cartflows-pro-optin-meta.php';
		}
	}
}

/**
 *  Kicking this off by calling 'get_instance()' method
 */
Cartflows_Pro_Legacy_Modules_Meta::get_instance();
