<?php
/**
 * Modules Loader
 *
 * @package Beaver Builder Modules
 */

/**
 * Initial Setup
 *
 * @since x.x.x
 */
class Cartflows_Pro_BB_Modules_Loader {

	/**
	 * Member Variable
	 *
	 * @var object instance
	 */
	private static $instance;

	/**
	 *  Initiator
	 */
	public static function get_instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Constructor function that initializes required actions and hooks
	 */
	public function __construct() {
		add_action( 'wp', array( $this, 'init' ), 2 );
		$this->modules_extend_files();
	}

	/**
	 * Function that initializes init function
	 *
	 * @since x.x.x
	 */
	public function init() {
		$this->include_modules_files();
	}

	/**
	 * Returns Script array.
	 *
	 * @return array()
	 * @since x.x.x
	 */
	public static function get_module_list() {

		$widget_list = array(
			'cartflows-pro-bb-offer-action-button',
			'cartflows-pro-bb-offer-action-link',
			'cartflows-pro-bb-offer-product-description',
			'cartflows-pro-bb-offer-product-price',
			'cartflows-pro-bb-offer-product-variation',
			'cartflows-pro-bb-offer-product-image',
			'cartflows-pro-bb-offer-product-title',
			'cartflows-pro-bb-offer-product-quantity',
		);

		return $widget_list;
	}

	/**
	 * Include Widgets files
	 *
	 * Load widgets files
	 *
	 * @since x.x.x
	 * @access public
	 */
	public function include_modules_files() {

		global $post;

		if ( ! isset( $post ) ) {
			return;
		}

		$post_type = $post->post_type;

		if ( 'cartflows_step' === $post_type && class_exists( 'FLBuilder' ) ) {

			include_once CARTFLOWS_PRO_DIR . 'modules/beaver-builder/classes/class-cartflows-pro-bb-helper.php';

			$widget_list = $this->get_module_list();

			if ( ! empty( $widget_list ) ) {
				foreach ( $widget_list as $handle => $data ) {
					include_once CARTFLOWS_PRO_DIR . 'modules/beaver-builder/' . $data . '/' . $data . '.php';
				}
			}
		}
	}

	/**
	 * Extend widget with pro functionality.
	 *
	 * @since x.x.x
	 */
	public function modules_extend_files() {

		if ( class_exists( 'FLBuilder' ) ) {
			require_once CARTFLOWS_PRO_DIR . 'modules/beaver-builder/cartflows-pro-bb-checkout-form-extend/cartflows-pro-bb-checkout-form-extend.php';
			require_once CARTFLOWS_PRO_DIR . 'modules/beaver-builder/cartflows-pro-bb-optin-form-extend/cartflows-pro-bb-optin-form-extend.php';
		}

	}

}

/**
 *  Kicking this off by calling 'get_instance()' method
 */
Cartflows_Pro_BB_Modules_Loader::get_instance();
