/**
 * Block Icons
 */

const el = wp.element.createElement

const CFP_Block_Icons = {
	"simple_block": el("svg", { width: 20, height: 20 },
		el("path", { fill: "#4a00e0", d: "M20 18.008h-20v-16.016h20v16.016zM1.172 16.836h17.656v-13.672h-17.656v13.672z" } ),
		el("path", { fill: "#4a00e0", d: "M7.617 4.604h4.766v1.172h-4.766v-1.172z" } ),
		el("path", { fill: "#4a00e0", d: "M8.998 14.385h-6.237v-6.238h6.238v6.238zM3.932 13.213h3.894v-3.894h-3.894v3.894z" } ),
		el("path", { fill: "#4a00e0", d: "M17.24 11.852h-6.237v-3.705h6.238v3.705zM12.174 10.68h3.894v-1.361h-3.894v1.361z" } ),
		el("path", { fill: "#4a00e0", d: "M11.588 13.024h5.066v1.172h-5.066v-1.172z" } )
	),
	"vertical_spacing": el("svg", { width: 20, height: 20 },
		el("path", { fill: "#999", d: "M17 0.999c1.103 0 2 0.897 2 2v14c0 1.103-0.897 2-2 2h-14c-1.103 0-2-0.897-2-2v-14c0-1.103 0.897-2 2-2h14zM17-0.001h-14c-1.657 0-3 1.343-3 3v14c0 1.657 1.343 3 3 3h14c1.657 0 3-1.343 3-3v-14c0-1.656-1.343-3-3-3v0z" } ),
		el( "path", { fill: "#575E67", d: "M17 0.983h-14c-1.103 0-2 0.896-2 2v0.797h18v-0.797c0-1.103-0.896-2-2-2z" } ),
		el( "path", { fill: "#575E67", d: "M3 19.031h14c1.103 0 2-0.896 2-2v-0.797h-18v0.797c0 1.104 0.896 2 2 2z" } )
	),
	"horizontal_spacing": el("svg", { width: 20, height: 20 },
		el("path", { fill: "#999", d: "M17 0.999c1.103 0 2 0.897 2 2v14c0 1.103-0.897 2-2 2h-14c-1.103 0-2-0.897-2-2v-14c0-1.103 0.897-2 2-2h14zM17-0.001h-14c-1.657 0-3 1.343-3 3v14c0 1.657 1.343 3 3 3h14c1.656 0 3-1.343 3-3v-14c0-1.657-1.343-3-3-3v0z" } ),
		el( "path", { fill: "#575E67", d: "M19.016 16.999v-14c0-1.103-0.896-2-2-2h-0.797v18h0.797c1.103 0 2-0.896 2-2z" } ),
		el( "path", { fill: "#575E67", d: "M0.968 2.999v14c0 1.103 0.896 2 2 2h0.797v-18h-0.797c-1.104 0-2 0.897-2 2z" } )
	),
	"yes_no_links": el("svg", { width: 30, height: 30, viewBox:"0 0 32 32"  },
		el("path", { fill: "#f16334", d: "M31.807 26.148l-3.801-3.786 1.864-1.857c0.161-0.161 0.228-0.394 0.175-0.615s-0.216-0.4-0.433-0.472l-11.186-3.713c-0.237-0.079-0.498-0.017-0.674 0.159s-0.238 0.436-0.159 0.672l3.729 11.14c0.072 0.216 0.252 0.379 0.474 0.431s0.456-0.014 0.617-0.175l1.864-1.857 3.801 3.786c0.129 0.128 0.297 0.192 0.466 0.192s0.337-0.064 0.466-0.192l2.796-2.785c0.257-0.256 0.257-0.672 0-0.928zM28.544 28.469l-3.801-3.786c-0.257-0.256-0.675-0.256-0.932 0l-1.576 1.57-2.974-8.887 8.923 2.962-1.576 1.57c-0.257 0.256-0.257 0.672 0 0.928l3.801 3.786-1.864 1.857zM15.456 11.757c-0.014 0.034-0.033 0.062-0.056 0.083s-0.055 0.038-0.097 0.051c-0.042 0.013-0.094 0.023-0.155 0.029s-0.14 0.010-0.235 0.010c-0.118 0-0.214-0.005-0.289-0.016s-0.132-0.026-0.17-0.047-0.061-0.048-0.067-0.081c-0.006-0.033 0-0.072 0.017-0.116l2.579-6.603c0.011-0.034 0.029-0.062 0.052-0.085s0.055-0.040 0.095-0.053c0.040-0.013 0.093-0.023 0.157-0.030s0.143-0.010 0.235-0.010c0.121 0 0.218 0.005 0.291 0.016s0.129 0.026 0.166 0.047c0.037 0.021 0.059 0.048 0.065 0.081s0.001 0.071-0.013 0.116l-2.575 6.607zM14.097 9.614c0 0.199-0.041 0.375-0.123 0.527s-0.198 0.279-0.347 0.381c-0.149 0.102-0.326 0.179-0.53 0.23s-0.426 0.077-0.664 0.077c-0.144 0-0.281-0.010-0.412-0.029s-0.248-0.045-0.352-0.075c-0.103-0.030-0.19-0.061-0.259-0.092s-0.119-0.061-0.151-0.089c-0.032-0.027-0.056-0.071-0.073-0.13s-0.026-0.146-0.026-0.262c0-0.076 0.003-0.137 0.009-0.183s0.014-0.083 0.026-0.11c0.012-0.028 0.026-0.046 0.043-0.055s0.039-0.014 0.065-0.014c0.032 0 0.078 0.016 0.14 0.049s0.139 0.069 0.231 0.108c0.092 0.039 0.199 0.076 0.321 0.11s0.261 0.051 0.416 0.051c0.098 0 0.185-0.009 0.261-0.027s0.142-0.045 0.198-0.079c0.056-0.034 0.099-0.077 0.127-0.13s0.043-0.113 0.043-0.181c0-0.079-0.027-0.146-0.080-0.203s-0.124-0.105-0.211-0.147c-0.088-0.042-0.187-0.081-0.298-0.118s-0.224-0.077-0.341-0.122-0.23-0.096-0.341-0.153c-0.111-0.058-0.21-0.128-0.298-0.212s-0.158-0.185-0.211-0.303-0.080-0.26-0.080-0.425c0-0.168 0.036-0.322 0.108-0.462s0.175-0.26 0.311-0.36c0.135-0.1 0.3-0.177 0.494-0.232s0.412-0.083 0.653-0.083c0.121 0 0.238 0.008 0.351 0.024s0.216 0.035 0.308 0.059 0.17 0.049 0.233 0.077c0.063 0.027 0.109 0.051 0.136 0.071s0.047 0.039 0.058 0.059c0.012 0.020 0.020 0.043 0.026 0.071s0.011 0.062 0.015 0.102c0.004 0.041 0.007 0.091 0.007 0.151 0 0.071-0.002 0.128-0.007 0.173s-0.011 0.080-0.022 0.106c-0.010 0.026-0.024 0.044-0.041 0.053s-0.037 0.014-0.060 0.014c-0.026 0-0.066-0.014-0.121-0.041s-0.123-0.057-0.205-0.088c-0.082-0.032-0.177-0.061-0.285-0.089s-0.231-0.041-0.369-0.041c-0.098 0-0.183 0.009-0.254 0.027s-0.131 0.045-0.177 0.079c-0.046 0.034-0.081 0.074-0.104 0.12s-0.035 0.095-0.035 0.148c0 0.081 0.027 0.149 0.082 0.204s0.127 0.104 0.216 0.146c0.089 0.042 0.19 0.081 0.304 0.118s0.229 0.077 0.345 0.12c0.116 0.043 0.232 0.094 0.345 0.151s0.215 0.128 0.304 0.212c0.089 0.084 0.161 0.184 0.216 0.301s0.082 0.255 0.082 0.415zM7.821 9.103c0 0.15 0.019 0.285 0.058 0.407s0.101 0.225 0.186 0.311 0.194 0.15 0.328 0.195c0.134 0.044 0.294 0.067 0.481 0.067 0.19 0 0.357-0.012 0.5-0.037s0.268-0.052 0.373-0.083c0.105-0.030 0.192-0.058 0.261-0.083s0.125-0.037 0.168-0.037c0.026 0 0.048 0.005 0.065 0.014s0.032 0.026 0.043 0.049c0.011 0.024 0.019 0.057 0.024 0.1s0.007 0.098 0.007 0.163c0 0.058-0.002 0.107-0.004 0.148s-0.007 0.075-0.013 0.104c-0.006 0.029-0.014 0.053-0.026 0.073s-0.027 0.039-0.045 0.057c-0.019 0.018-0.070 0.043-0.153 0.075s-0.19 0.062-0.319 0.092c-0.129 0.030-0.277 0.056-0.444 0.079s-0.345 0.033-0.535 0.033c-0.342 0-0.642-0.039-0.899-0.118s-0.472-0.198-0.645-0.358c-0.173-0.16-0.301-0.362-0.386-0.606s-0.127-0.53-0.127-0.857c0-0.312 0.045-0.593 0.134-0.844s0.219-0.463 0.388-0.637c0.17-0.174 0.376-0.308 0.619-0.399s0.517-0.138 0.822-0.138c0.322 0 0.597 0.043 0.826 0.13s0.416 0.207 0.563 0.36c0.147 0.153 0.255 0.335 0.324 0.545s0.103 0.438 0.103 0.684v0.157c0 0.121-0.029 0.21-0.088 0.268s-0.14 0.086-0.244 0.086h-2.342zM28.417 8.816c0 0.299-0.043 0.572-0.129 0.818s-0.217 0.459-0.392 0.637c-0.175 0.178-0.395 0.316-0.66 0.413s-0.574 0.145-0.927 0.145c-0.342 0-0.64-0.043-0.893-0.13s-0.463-0.212-0.63-0.378-0.29-0.368-0.371-0.61c-0.081-0.241-0.121-0.516-0.121-0.826 0-0.299 0.044-0.572 0.132-0.82s0.219-0.46 0.395-0.637 0.395-0.314 0.658-0.411c0.263-0.097 0.572-0.146 0.925-0.146 0.345 0 0.644 0.043 0.897 0.128s0.462 0.21 0.628 0.376c0.165 0.165 0.288 0.368 0.369 0.61s0.121 0.518 0.121 0.83zM5.38 8.808v1.79c0 0.026-0.009 0.050-0.028 0.071s-0.050 0.038-0.093 0.051c-0.043 0.013-0.101 0.024-0.175 0.031s-0.165 0.012-0.274 0.012c-0.112 0-0.204-0.004-0.276-0.012s-0.13-0.018-0.175-0.031c-0.045-0.013-0.076-0.030-0.093-0.051s-0.026-0.045-0.026-0.071v-1.79l-1.527-2.773c-0.055-0.097-0.090-0.172-0.106-0.226s-0.007-0.094 0.026-0.122c0.033-0.027 0.094-0.045 0.183-0.051s0.213-0.010 0.371-0.010c0.132 0 0.238 0.003 0.317 0.008s0.142 0.015 0.188 0.029 0.080 0.033 0.101 0.057c0.022 0.024 0.042 0.054 0.063 0.091l0.621 1.251c0.060 0.121 0.12 0.248 0.179 0.382s0.119 0.274 0.179 0.421h0.009c0.055-0.142 0.111-0.279 0.168-0.413s0.114-0.261 0.168-0.382l0.612-1.243c0.014-0.042 0.032-0.075 0.054-0.1s0.054-0.045 0.097-0.061 0.102-0.026 0.177-0.031c0.075-0.005 0.174-0.008 0.298-0.008 0.164 0 0.291 0.003 0.382 0.010s0.152 0.024 0.185 0.051c0.033 0.028 0.041 0.069 0.024 0.124s-0.052 0.13-0.104 0.224l-1.527 2.773zM19.76 6.786c0.012 0.189 0.020 0.377 0.026 0.564s0.009 0.381 0.009 0.58v2.663c0 0.026-0.008 0.050-0.024 0.071s-0.043 0.039-0.082 0.053c-0.039 0.014-0.091 0.026-0.157 0.033s-0.151 0.012-0.254 0.012c-0.101 0-0.184-0.004-0.25-0.012s-0.118-0.019-0.155-0.033c-0.037-0.014-0.063-0.032-0.078-0.053s-0.021-0.045-0.021-0.071v-4.574c0-0.123 0.039-0.216 0.119-0.277s0.176-0.093 0.291-0.093h0.608c0.109 0 0.201 0.009 0.276 0.026s0.142 0.045 0.201 0.085 0.114 0.094 0.166 0.163c0.052 0.070 0.105 0.155 0.159 0.258l1.087 1.86c0.063 0.113 0.126 0.223 0.188 0.332s0.122 0.218 0.179 0.327c0.058 0.109 0.114 0.216 0.168 0.32s0.108 0.21 0.16 0.315h0.004c-0.009-0.183-0.015-0.375-0.019-0.574s-0.007-0.389-0.007-0.57v-2.387c0-0.026 0.009-0.050 0.026-0.071s0.046-0.039 0.086-0.055 0.093-0.027 0.16-0.033c0.066-0.007 0.151-0.010 0.254-0.010 0.098 0 0.18 0.003 0.246 0.010s0.117 0.018 0.153 0.033c0.036 0.016 0.061 0.034 0.076 0.055s0.022 0.045 0.022 0.071v4.574c0 0.060-0.012 0.114-0.035 0.161s-0.054 0.087-0.093 0.118c-0.039 0.031-0.085 0.054-0.138 0.069s-0.107 0.022-0.162 0.022h-0.483c-0.101 0-0.188-0.009-0.261-0.027s-0.141-0.052-0.203-0.1c-0.062-0.048-0.122-0.114-0.179-0.197s-0.122-0.189-0.194-0.321l-1.389-2.379c-0.081-0.142-0.162-0.294-0.246-0.458s-0.158-0.323-0.224-0.478h-0.009zM27.3 8.855c0-0.173-0.015-0.332-0.045-0.478s-0.081-0.272-0.153-0.38c-0.072-0.107-0.168-0.191-0.287-0.252s-0.27-0.090-0.451-0.090c-0.161 0-0.302 0.027-0.423 0.081s-0.22 0.132-0.298 0.236c-0.078 0.103-0.136 0.228-0.175 0.374s-0.058 0.311-0.058 0.497c0 0.173 0.016 0.332 0.047 0.478s0.083 0.272 0.153 0.379c0.070 0.108 0.166 0.191 0.287 0.25s0.27 0.089 0.449 0.089c0.164 0 0.306-0.027 0.427-0.081s0.22-0.132 0.298-0.234c0.078-0.102 0.135-0.226 0.172-0.372s0.056-0.311 0.056-0.498zM9.443 8.466c0.009-0.278-0.052-0.496-0.183-0.655s-0.333-0.238-0.606-0.238c-0.138 0-0.258 0.024-0.36 0.071s-0.187 0.111-0.255 0.191c-0.067 0.080-0.119 0.174-0.155 0.283s-0.057 0.225-0.063 0.348h1.622z"} )
	),
	"yes_no_button": el("svg", { width: 30, height: 30, viewBox:"0 0 32 32"  },
		el("path", { fill: "#f16334", d:"M18.985 21.944c-5.187 0.008-10.374 0.010-15.56-0.015-1.354-0.011-2.649-0.877-3.166-2.141-0.167-0.409-0.253-0.85-0.255-1.29-0.003-1.82-0.009-3.64 0-5.46 0.011-1.342 0.87-2.646 2.141-3.166 0.408-0.167 0.849-0.253 1.29-0.255 8.048-0.013 16.097-0.013 24.146 0 1.347 0.006 2.657 0.87 3.177 2.142 0.167 0.408 0.253 0.85 0.255 1.29 0.003 1.82 0.008 3.64 0 5.46-0.007 0.907-0.396 1.804-1.044 2.444 0.034 0.057 0.060 0.12 0.076 0.186 0.052 0.221-0.014 0.454-0.175 0.615l-1.864 1.857 3.801 3.786c0.257 0.256 0.257 0.672 0 0.928l-2.796 2.785c-0.129 0.128-0.297 0.192-0.466 0.192s-0.337-0.064-0.466-0.192l-3.801-3.786-1.864 1.857c-0.162 0.161-0.395 0.227-0.617 0.175s-0.402-0.215-0.474-0.431l-2.336-6.98zM27.974 21.506l-8.713-2.893 2.974 8.887 1.576-1.57c0.257-0.256 0.675-0.256 0.932 0l3.801 3.786 1.864-1.857-3.801-3.786c-0.257-0.256-0.257-0.672 0-0.928l1.366-1.361v-0.279zM28.421 20.271c0.44-0.213 0.806-0.584 0.992-1.047 0.092-0.23 0.14-0.477 0.142-0.725 0.008-1.82 0.015-3.64-0-5.459-0.009-0.79-0.527-1.55-1.28-1.836-0.22-0.084-0.455-0.127-0.691-0.129-8.045-0.038-16.091 0-24.136 0-0.787 0.001-1.546 0.508-1.843 1.246-0.092 0.23-0.14 0.478-0.142 0.725-0.009 1.82-0.014 3.639 0 5.459 0.011 1.015 0.882 1.956 1.971 1.965 5.023 0.024 10.047 0.043 15.070 0.038l-0.912-2.725c-0.079-0.236-0.017-0.496 0.159-0.672s0.438-0.237 0.674-0.159l9.994 3.318zM15.456 7.565c-0.014 0.034-0.033 0.062-0.056 0.083s-0.055 0.038-0.097 0.051c-0.042 0.013-0.094 0.023-0.155 0.029s-0.14 0.010-0.235 0.010c-0.118 0-0.214-0.005-0.289-0.016s-0.132-0.026-0.17-0.047-0.061-0.048-0.067-0.081c-0.006-0.033 0-0.072 0.017-0.116l2.579-6.603c0.011-0.034 0.029-0.062 0.052-0.085s0.055-0.040 0.095-0.053c0.040-0.013 0.093-0.023 0.157-0.030s0.143-0.010 0.235-0.010c0.121 0 0.218 0.005 0.291 0.016s0.129 0.026 0.166 0.047c0.037 0.021 0.059 0.048 0.065 0.081s0.001 0.071-0.013 0.116l-2.575 6.607zM14.097 5.422c0 0.199-0.041 0.375-0.123 0.527s-0.198 0.279-0.347 0.381c-0.149 0.102-0.326 0.179-0.53 0.23s-0.426 0.077-0.664 0.077c-0.144 0-0.281-0.010-0.412-0.029s-0.248-0.045-0.352-0.075c-0.103-0.030-0.19-0.061-0.259-0.092s-0.119-0.061-0.151-0.089c-0.032-0.027-0.056-0.071-0.073-0.13s-0.026-0.146-0.026-0.262c0-0.076 0.003-0.137 0.009-0.183s0.014-0.083 0.026-0.11c0.012-0.028 0.026-0.046 0.043-0.055s0.039-0.014 0.065-0.014c0.032 0 0.078 0.016 0.14 0.049s0.139 0.069 0.231 0.108c0.092 0.039 0.199 0.076 0.321 0.11s0.261 0.051 0.416 0.051c0.098 0 0.185-0.009 0.261-0.027s0.142-0.045 0.198-0.079c0.056-0.034 0.099-0.077 0.127-0.13s0.043-0.113 0.043-0.181c0-0.079-0.027-0.146-0.080-0.203s-0.124-0.105-0.211-0.147c-0.088-0.042-0.187-0.081-0.298-0.118s-0.224-0.077-0.341-0.122-0.23-0.096-0.341-0.153c-0.111-0.058-0.21-0.128-0.298-0.212s-0.158-0.185-0.211-0.303-0.080-0.26-0.080-0.425c0-0.168 0.036-0.322 0.108-0.462s0.175-0.26 0.311-0.36c0.135-0.1 0.3-0.177 0.494-0.232s0.412-0.083 0.653-0.083c0.121 0 0.238 0.008 0.351 0.024s0.216 0.035 0.308 0.059 0.17 0.049 0.233 0.077c0.063 0.027 0.109 0.051 0.136 0.071s0.047 0.039 0.058 0.059c0.012 0.020 0.020 0.043 0.026 0.071s0.011 0.062 0.015 0.102c0.004 0.041 0.007 0.091 0.007 0.151 0 0.071-0.002 0.128-0.007 0.173s-0.011 0.080-0.022 0.106c-0.010 0.026-0.024 0.044-0.041 0.053s-0.037 0.014-0.060 0.014c-0.026 0-0.066-0.014-0.121-0.041s-0.123-0.057-0.205-0.088c-0.082-0.032-0.177-0.061-0.285-0.089s-0.231-0.041-0.369-0.041c-0.098 0-0.183 0.009-0.254 0.027s-0.131 0.045-0.177 0.079c-0.046 0.034-0.081 0.074-0.104 0.12s-0.035 0.095-0.035 0.148c0 0.081 0.027 0.149 0.082 0.204s0.127 0.104 0.216 0.146c0.089 0.042 0.19 0.081 0.304 0.118s0.229 0.077 0.345 0.12c0.116 0.043 0.232 0.094 0.345 0.151s0.215 0.128 0.304 0.212c0.089 0.084 0.161 0.184 0.216 0.301s0.082 0.255 0.082 0.415zM10.496 4.557c0 0.121-0.029 0.21-0.088 0.268s-0.14 0.086-0.244 0.086h-2.342c0 0.15 0.019 0.285 0.058 0.407s0.101 0.225 0.186 0.311 0.194 0.15 0.328 0.195c0.134 0.044 0.294 0.067 0.481 0.067 0.19 0 0.357-0.012 0.5-0.037s0.268-0.052 0.373-0.083c0.105-0.030 0.192-0.058 0.261-0.083s0.125-0.037 0.168-0.037c0.026 0 0.048 0.005 0.065 0.014s0.032 0.026 0.043 0.049c0.011 0.024 0.019 0.057 0.024 0.1s0.007 0.098 0.007 0.163c0 0.058-0.002 0.107-0.004 0.148s-0.007 0.075-0.013 0.104c-0.006 0.029-0.014 0.053-0.026 0.073s-0.027 0.039-0.045 0.057c-0.019 0.018-0.070 0.043-0.153 0.075s-0.19 0.062-0.319 0.092c-0.129 0.030-0.277 0.056-0.444 0.079s-0.345 0.033-0.535 0.033c-0.342 0-0.642-0.039-0.899-0.118s-0.472-0.198-0.645-0.358c-0.173-0.16-0.301-0.362-0.386-0.606s-0.127-0.53-0.127-0.857c0-0.312 0.045-0.593 0.134-0.844s0.219-0.463 0.388-0.637c0.17-0.174 0.376-0.308 0.619-0.399s0.517-0.138 0.822-0.138c0.322 0 0.597 0.043 0.826 0.13s0.416 0.207 0.563 0.36c0.147 0.153 0.255 0.335 0.324 0.545s0.103 0.438 0.103 0.684v0.157zM28.417 4.624c0 0.299-0.043 0.572-0.129 0.818s-0.217 0.459-0.392 0.637c-0.175 0.178-0.395 0.316-0.66 0.413s-0.574 0.145-0.927 0.145c-0.342 0-0.64-0.043-0.893-0.13s-0.463-0.212-0.63-0.378-0.29-0.368-0.371-0.61c-0.081-0.241-0.121-0.516-0.121-0.826 0-0.299 0.044-0.572 0.132-0.82s0.219-0.46 0.395-0.637 0.395-0.314 0.658-0.411c0.263-0.097 0.572-0.146 0.925-0.146 0.345 0 0.644 0.043 0.897 0.128s0.462 0.21 0.628 0.376c0.165 0.165 0.288 0.368 0.369 0.61s0.121 0.518 0.121 0.83zM22.948 6.555h-0.483c-0.101 0-0.188-0.009-0.261-0.027s-0.141-0.052-0.203-0.1c-0.062-0.048-0.122-0.114-0.179-0.197s-0.122-0.189-0.194-0.321l-1.389-2.379c-0.081-0.142-0.162-0.294-0.246-0.458s-0.158-0.323-0.224-0.478h-0.009c0.012 0.189 0.020 0.377 0.026 0.564s0.009 0.381 0.009 0.58v2.663c0 0.026-0.008 0.050-0.024 0.071s-0.043 0.039-0.082 0.053c-0.039 0.014-0.091 0.026-0.157 0.033s-0.151 0.012-0.254 0.012c-0.101 0-0.184-0.004-0.25-0.012s-0.118-0.019-0.155-0.033c-0.037-0.014-0.063-0.032-0.078-0.053s-0.021-0.045-0.021-0.071v-4.574c0-0.123 0.039-0.216 0.119-0.277s0.176-0.093 0.291-0.093h0.608c0.109 0 0.201 0.009 0.276 0.026s0.142 0.045 0.201 0.085 0.114 0.094 0.166 0.163c0.052 0.070 0.105 0.155 0.159 0.258l1.087 1.86c0.063 0.113 0.126 0.223 0.188 0.332s0.122 0.218 0.179 0.327c0.058 0.109 0.114 0.216 0.168 0.32s0.108 0.21 0.16 0.315h0.004c-0.009-0.183-0.015-0.375-0.019-0.574s-0.007-0.389-0.007-0.57v-2.387c0-0.026 0.009-0.050 0.026-0.071s0.046-0.039 0.086-0.055 0.093-0.027 0.16-0.033c0.066-0.007 0.151-0.010 0.254-0.010 0.098 0 0.18 0.003 0.246 0.010s0.117 0.018 0.153 0.033c0.036 0.016 0.061 0.034 0.076 0.055s0.022 0.045 0.022 0.071v4.574c0 0.060-0.012 0.114-0.035 0.161s-0.054 0.087-0.093 0.118c-0.039 0.031-0.085 0.054-0.138 0.069s-0.107 0.022-0.162 0.022zM5.38 4.616v1.79c0 0.026-0.009 0.050-0.028 0.071s-0.050 0.038-0.093 0.051c-0.043 0.013-0.101 0.024-0.175 0.031s-0.165 0.012-0.274 0.012c-0.112 0-0.204-0.004-0.276-0.012s-0.13-0.018-0.175-0.031c-0.045-0.013-0.076-0.030-0.093-0.051s-0.026-0.045-0.026-0.071v-1.79l-1.527-2.773c-0.055-0.097-0.090-0.172-0.106-0.226s-0.007-0.094 0.026-0.122c0.033-0.027 0.094-0.045 0.183-0.051s0.213-0.010 0.371-0.010c0.132 0 0.238 0.003 0.317 0.008s0.142 0.015 0.188 0.029 0.080 0.033 0.101 0.057c0.022 0.024 0.042 0.054 0.063 0.091l0.621 1.251c0.060 0.121 0.12 0.248 0.179 0.382s0.119 0.274 0.179 0.421h0.009c0.055-0.142 0.111-0.279 0.168-0.413s0.114-0.261 0.168-0.382l0.612-1.243c0.014-0.042 0.032-0.075 0.054-0.1s0.054-0.045 0.097-0.061 0.102-0.026 0.177-0.031c0.075-0.005 0.174-0.008 0.298-0.008 0.164 0 0.291 0.003 0.382 0.010s0.152 0.024 0.185 0.051c0.033 0.028 0.041 0.069 0.024 0.124s-0.052 0.13-0.104 0.224l-1.527 2.773zM27.3 4.663c0-0.173-0.015-0.332-0.045-0.478s-0.081-0.272-0.153-0.38c-0.072-0.107-0.168-0.191-0.287-0.252s-0.27-0.090-0.451-0.090c-0.161 0-0.302 0.027-0.423 0.081s-0.22 0.132-0.298 0.236c-0.078 0.103-0.136 0.228-0.175 0.374s-0.058 0.311-0.058 0.497c0 0.173 0.016 0.332 0.047 0.478s0.083 0.272 0.153 0.379c0.070 0.108 0.166 0.191 0.287 0.25s0.27 0.089 0.449 0.089c0.164 0 0.306-0.027 0.427-0.081s0.22-0.132 0.298-0.234c0.078-0.102 0.135-0.226 0.172-0.372s0.056-0.311 0.056-0.498zM9.443 4.274c0.009-0.278-0.052-0.496-0.183-0.655s-0.333-0.238-0.606-0.238c-0.138 0-0.258 0.024-0.36 0.071s-0.187 0.111-0.255 0.191c-0.067 0.080-0.119 0.174-0.155 0.283s-0.057 0.225-0.063 0.348h1.622z"} ),
	),
	"offer_product_description": el("svg", { width: 30, height: 30, viewBox:"0 0 32 32"  },
		el("path", { fill: "#f16334", d:"M18.098 26.973l-5.112 2.838c-0.095 0.051-0.206 0.071-0.311 0.054-0.016-0.003-0.032-0.007-0.048-0.012l-0.010-0.001-0.017-0.009c-0.029-0.011-0.057-0.024-0.085-0.034l-12.26-6.76c-0.045-0.037-0.098-0.066-0.136-0.11-0.104-0.121-0.093-0.173-0.119-0.323l0.033-13.266 0.002-0.012c-0-0.040 0.005-0.082 0.017-0.124 0.034-0.119 0.067-0.19 0.236-0.295l12.226-6.728c0.063-0.031 0.085-0.062 0.246-0.060 0.053-0.006 0.073 0.001 0.097 0.002 0.085 0.014 0.106 0.021 0.183 0.059l6.654 3.745-0.25-0.512c-0.274-0.561-0.057-1.23 0.495-1.522l0.991-0.526c0.107-0.057 0.18-0.158 0.201-0.277l0.194-1.105c0.108-0.615 0.677-1.028 1.295-0.941l1.111 0.157c0.12 0.017 0.238-0.022 0.325-0.106l0.806-0.78c0.449-0.434 1.152-0.434 1.601 0l0.806 0.78c0.087 0.084 0.206 0.123 0.325 0.106l1.111-0.157c0.618-0.087 1.187 0.326 1.295 0.941l0.194 1.105c0.021 0.119 0.094 0.22 0.201 0.277l0.991 0.526c0.552 0.293 0.769 0.962 0.495 1.523l-0.493 1.008c-0.053 0.109-0.053 0.233 0 0.342l0.493 1.008c0.274 0.561 0.057 1.23-0.495 1.523l-0.991 0.526c-0.107 0.057-0.18 0.158-0.201 0.277l-0.194 1.105c-0.108 0.615-0.677 1.028-1.295 0.941l-1.111-0.157c-0.12-0.017-0.238 0.022-0.325 0.106l-0.806 0.78c-0.224 0.217-0.513 0.326-0.801 0.326-0.064 0-0.128-0.005-0.191-0.016v5.411h4.934c0.879 0 1.593 0.751 1.593 1.675v10.048c0 0.924-0.714 1.675-1.593 1.675h-10.716c-0.879 0-1.593-0.751-1.593-1.675v-3.352zM31.131 21.648h-12.164v8.678c0 0.42 0.325 0.761 0.724 0.761h10.716c0.399 0 0.724-0.342 0.724-0.761v-8.678zM29.828 29.26c0.24 0 0.434-0.205 0.434-0.457s-0.195-0.457-0.434-0.457h-9.232c-0.24 0-0.434 0.205-0.434 0.457s0.195 0.457 0.434 0.457h9.232zM0.987 22.327l11.272 6.216v-12.265l-11.242-6.099c-0.010 4.049-0.020 8.098-0.031 12.148zM24.486 18.603v-6.086l-0.429-0.415c-0.087-0.084-0.206-0.123-0.325-0.106l-1.111 0.157c-0.055 0.008-0.111 0.012-0.165 0.012-0.337 0-0.647-0.146-0.86-0.388l-8.35 4.595v12.168l4.852-2.695v-5.567c0-0.924 0.714-1.675 1.593-1.675h4.795zM29.828 26.824c0.24 0 0.434-0.205 0.434-0.457s-0.195-0.457-0.434-0.457h-9.232c-0.24 0-0.434 0.205-0.434 0.457s0.195 0.457 0.434 0.457h9.232zM29.828 24.388c0.24 0 0.434-0.205 0.434-0.457s-0.195-0.457-0.434-0.457h-9.232c-0.24 0-0.434 0.205-0.434 0.457s0.195 0.457 0.434 0.457h9.232zM30.407 19.516h-10.716c-0.399 0-0.724 0.342-0.724 0.761v0.457h12.164v-0.457c0-0.42-0.325-0.761-0.724-0.761zM19.801 7.054l-0.923-0.51-11.166 6.145 5.126 2.781 8.421-4.635-0.128-0.728c-0.021-0.119-0.094-0.22-0.201-0.277l-0.991-0.526c-0.552-0.293-0.769-0.962-0.495-1.523l0.356-0.728zM31.030 8.632c0.187-0.099 0.26-0.325 0.167-0.515l-0.493-1.008c-0.157-0.321-0.157-0.69 0-1.011l0.493-1.008c0.093-0.19 0.019-0.416-0.167-0.515l-0.991-0.526c-0.316-0.168-0.533-0.466-0.594-0.818l-0.194-1.105c-0.036-0.208-0.229-0.348-0.438-0.318l-1.111 0.157c-0.354 0.050-0.705-0.064-0.962-0.313l-0.806-0.78c-0.152-0.147-0.39-0.147-0.542 0l-0.806 0.78c-0.257 0.249-0.608 0.363-0.962 0.313l-1.111-0.157c-0.209-0.030-0.402 0.11-0.438 0.318l-0.194 1.105c-0.062 0.352-0.278 0.65-0.594 0.818l-0.991 0.526c-0.187 0.099-0.26 0.325-0.167 0.515l0.493 1.008c0.157 0.321 0.157 0.69 0 1.011l-0.493 1.008c-0.093 0.19-0.019 0.416 0.167 0.515l0.991 0.526c0.316 0.168 0.533 0.466 0.594 0.818l0.194 1.105c0.037 0.208 0.229 0.348 0.438 0.318l1.111-0.157c0.055-0.008 0.11-0.012 0.164-0.012 0.296 0 0.58 0.114 0.798 0.324l0.806 0.78c0.152 0.147 0.39 0.147 0.542 0l0.806-0.78c0.257-0.249 0.608-0.363 0.962-0.312l1.111 0.157c0.209 0.030 0.402-0.11 0.438-0.318l0.194-1.105c0.062-0.352 0.279-0.65 0.594-0.818l0.991-0.526zM1.556 9.349l5.126 2.781 11.175-6.15-5.079-2.807-11.222 6.176zM27.187 7.239c-0.77 0-1.397 0.626-1.397 1.397s0.626 1.396 1.397 1.396c0.77 0 1.396-0.626 1.396-1.396s-0.626-1.397-1.396-1.397zM28.446 3.821c-0.149-0.149-0.39-0.149-0.539 0l-5.027 5.027c-0.149 0.149-0.149 0.39 0 0.539 0.074 0.074 0.172 0.112 0.269 0.112s0.195-0.037 0.269-0.112l5.027-5.027c0.149-0.149 0.149-0.39 0-0.539zM27.187 9.27c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635zM24.14 3.176c-0.77 0-1.397 0.626-1.397 1.396s0.627 1.397 1.397 1.397 1.397-0.626 1.397-1.397c0-0.77-0.627-1.396-1.397-1.396zM24.14 5.207c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635z"}),
	),
	"offer_product_title": el("svg", { width: 30, height: 30, viewBox:"0 0 32 32"  },
		el("path", { fill: "#f16334", d:"M18.113 26.965l-5.127 2.847c-0.095 0.051-0.206 0.071-0.311 0.054-0.016-0.003-0.032-0.007-0.048-0.012l-0.010-0.001-0.017-0.009c-0.029-0.011-0.057-0.024-0.085-0.034l-12.26-6.76c-0.045-0.037-0.098-0.066-0.136-0.11-0.104-0.121-0.093-0.173-0.119-0.323l0.033-13.266 0.002-0.012c-0-0.040 0.005-0.082 0.017-0.124 0.034-0.119 0.067-0.19 0.236-0.295l12.226-6.728c0.063-0.031 0.085-0.062 0.246-0.060 0.053-0.006 0.073 0.001 0.097 0.002 0.085 0.014 0.106 0.021 0.183 0.059l6.654 3.745-0.25-0.512c-0.274-0.561-0.057-1.23 0.495-1.522l0.991-0.526c0.107-0.057 0.18-0.158 0.201-0.277l0.194-1.105c0.108-0.615 0.677-1.028 1.295-0.941l1.111 0.157c0.12 0.017 0.238-0.022 0.325-0.106l0.806-0.78c0.449-0.434 1.152-0.434 1.601 0l0.806 0.78c0.087 0.084 0.206 0.123 0.325 0.106l1.111-0.157c0.618-0.087 1.187 0.326 1.295 0.941l0.194 1.105c0.021 0.119 0.094 0.22 0.201 0.277l0.991 0.526c0.552 0.293 0.769 0.962 0.495 1.523l-0.493 1.008c-0.053 0.109-0.053 0.233 0 0.342l0.493 1.008c0.274 0.561 0.057 1.23-0.495 1.523l-0.991 0.526c-0.107 0.057-0.18 0.158-0.201 0.277l-0.194 1.105c-0.108 0.615-0.677 1.028-1.295 0.941l-1.111-0.157c-0.12-0.017-0.238 0.022-0.325 0.106l-0.806 0.78c-0.224 0.217-0.513 0.326-0.801 0.326-0.064 0-0.128-0.005-0.191-0.016v5.411h4.936c0.878 0 1.591 0.751 1.591 1.675v10.048c0 0.924-0.713 1.675-1.591 1.675h-10.705c-0.878 0-1.591-0.751-1.591-1.675v-3.36zM31.132 21.648h-12.151v8.678c0 0.42 0.325 0.761 0.723 0.761h10.705c0.399 0 0.723-0.342 0.723-0.761v-8.678zM20.717 24.388h1.591v4.263h-0.289c-0.24 0-0.434 0.205-0.434 0.457s0.194 0.457 0.434 0.457h1.447c0.239-0 0.434-0.205 0.434-0.457s-0.194-0.457-0.434-0.457h-0.289v-4.263h1.591v0.457c0 0.252 0.194 0.457 0.434 0.457s0.434-0.205 0.434-0.457v-0.913c0-0.252-0.194-0.457-0.434-0.457h-4.918c-0.239 0-0.434 0.205-0.434 0.457v0.913c0 0.252 0.194 0.457 0.434 0.457s0.434-0.205 0.434-0.457v-0.457zM29.83 29.26c0.24 0 0.434-0.205 0.434-0.457s-0.194-0.457-0.434-0.457h-3.146c-0.24 0-0.434 0.205-0.434 0.457s0.194 0.457 0.434 0.457h3.146zM0.987 22.327l11.272 6.216v-12.265l-11.242-6.099c-0.010 4.049-0.020 8.098-0.031 12.148zM24.486 18.603v-6.086l-0.429-0.415c-0.087-0.084-0.206-0.123-0.325-0.106l-1.111 0.157c-0.055 0.008-0.111 0.012-0.165 0.012-0.337 0-0.647-0.146-0.86-0.388l-8.35 4.595v12.168l4.867-2.704v-5.559c0-0.924 0.713-1.675 1.591-1.675h4.782zM29.83 26.824c0.24 0 0.434-0.205 0.434-0.457s-0.194-0.457-0.434-0.457h-3.146c-0.24 0-0.434 0.205-0.434 0.457s0.194 0.457 0.434 0.457h3.146zM29.83 24.388c0.24 0 0.434-0.205 0.434-0.457s-0.194-0.457-0.434-0.457h-3.146c-0.24 0-0.434 0.205-0.434 0.457s0.194 0.457 0.434 0.457h3.146zM30.409 19.516h-10.705c-0.399 0-0.723 0.342-0.723 0.761v0.457h12.151v-0.457c0-0.42-0.325-0.761-0.723-0.761zM19.801 7.054l-0.923-0.51-11.166 6.145 5.126 2.781 8.421-4.635-0.128-0.728c-0.021-0.119-0.094-0.22-0.201-0.277l-0.991-0.526c-0.552-0.293-0.769-0.962-0.495-1.523l0.356-0.728zM31.030 8.632c0.187-0.099 0.26-0.325 0.167-0.515l-0.493-1.008c-0.157-0.321-0.157-0.69 0-1.011l0.493-1.008c0.093-0.19 0.019-0.416-0.167-0.515l-0.991-0.526c-0.316-0.168-0.533-0.466-0.594-0.818l-0.194-1.105c-0.036-0.208-0.229-0.348-0.438-0.318l-1.111 0.157c-0.354 0.050-0.705-0.064-0.962-0.313l-0.806-0.78c-0.152-0.147-0.39-0.147-0.542 0l-0.806 0.78c-0.257 0.249-0.608 0.363-0.962 0.313l-1.111-0.157c-0.209-0.030-0.402 0.11-0.438 0.318l-0.194 1.105c-0.062 0.352-0.278 0.65-0.594 0.818l-0.991 0.526c-0.187 0.099-0.26 0.325-0.167 0.515l0.493 1.008c0.157 0.321 0.157 0.69 0 1.011l-0.493 1.008c-0.093 0.19-0.019 0.416 0.167 0.515l0.991 0.526c0.316 0.168 0.533 0.466 0.594 0.818l0.194 1.105c0.037 0.208 0.229 0.348 0.438 0.318l1.111-0.157c0.055-0.008 0.11-0.012 0.164-0.012 0.296 0 0.58 0.114 0.798 0.324l0.806 0.78c0.152 0.147 0.39 0.147 0.542 0l0.806-0.78c0.257-0.249 0.608-0.363 0.962-0.312l1.111 0.157c0.209 0.030 0.402-0.11 0.438-0.318l0.194-1.105c0.062-0.352 0.279-0.65 0.594-0.818l0.991-0.526zM1.556 9.349l5.126 2.781 11.175-6.15-5.079-2.807-11.222 6.176zM27.187 7.239c-0.77 0-1.397 0.626-1.397 1.397s0.626 1.396 1.397 1.396c0.77 0 1.396-0.626 1.396-1.396s-0.626-1.397-1.396-1.397zM28.446 3.821c-0.149-0.149-0.39-0.149-0.539 0l-5.027 5.027c-0.149 0.149-0.149 0.39 0 0.539 0.074 0.074 0.172 0.112 0.269 0.112s0.195-0.037 0.269-0.112l5.027-5.027c0.149-0.149 0.149-0.39 0-0.539zM27.187 9.27c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635zM24.14 3.176c-0.77 0-1.397 0.626-1.397 1.396s0.627 1.397 1.397 1.397 1.397-0.626 1.397-1.397c0-0.77-0.627-1.396-1.397-1.396zM24.14 5.207c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635z"}),
	),
	"offer_product_price": el("svg", { width: 30, height: 30, viewBox:"0 0 32 32"  },
		el("path", { fill: "#f16334", d:"M17.594 27.254l-4.607 2.558c-0.095 0.051-0.206 0.071-0.311 0.054-0.016-0.003-0.032-0.007-0.048-0.012l-0.010-0.001-0.017-0.009c-0.029-0.011-0.057-0.024-0.085-0.034l-12.26-6.76c-0.045-0.037-0.098-0.066-0.136-0.11-0.104-0.121-0.093-0.173-0.119-0.323l0.033-13.266 0.002-0.012c-0-0.040 0.005-0.082 0.017-0.124 0.034-0.119 0.067-0.19 0.236-0.295l12.226-6.728c0.063-0.031 0.085-0.062 0.246-0.060 0.053-0.006 0.073 0.001 0.097 0.002 0.085 0.014 0.106 0.021 0.183 0.059l6.654 3.745-0.25-0.512c-0.274-0.561-0.057-1.23 0.495-1.522l0.991-0.526c0.107-0.057 0.18-0.158 0.201-0.277l0.194-1.105c0.108-0.615 0.677-1.028 1.295-0.941l1.111 0.157c0.12 0.017 0.238-0.022 0.325-0.106l0.806-0.78c0.449-0.434 1.152-0.434 1.601 0l0.806 0.78c0.087 0.084 0.206 0.123 0.325 0.106l1.111-0.157c0.618-0.087 1.187 0.326 1.295 0.941l0.194 1.105c0.021 0.119 0.094 0.22 0.201 0.277l0.991 0.526c0.552 0.293 0.769 0.962 0.495 1.523l-0.493 1.008c-0.053 0.109-0.053 0.233 0 0.342l0.493 1.008c0.274 0.561 0.057 1.23-0.495 1.523l-0.991 0.526c-0.107 0.057-0.18 0.158-0.201 0.277l-0.194 1.105c-0.108 0.615-0.677 1.028-1.295 0.941l-1.111-0.157c-0.12-0.017-0.238 0.022-0.325 0.106l-0.806 0.78c-0.224 0.217-0.513 0.326-0.801 0.326-0.064 0-0.128-0.005-0.191-0.016v3.953c1.64 0.203 3.157 0.94 4.344 2.127 1.408 1.408 2.184 3.281 2.184 5.272s-0.776 3.864-2.184 5.272c-1.408 1.408-3.281 2.184-5.272 2.184s-3.864-0.776-5.272-2.184c-0.742-0.742-1.308-1.613-1.678-2.562zM24.544 18.020c-3.597 0-6.524 2.927-6.524 6.524s2.927 6.524 6.524 6.524c3.597 0 6.524-2.927 6.524-6.524s-2.927-6.524-6.524-6.524zM24.544 24.078c1.156 0 2.097 0.941 2.097 2.097 0 0.996-0.698 1.832-1.631 2.044v0.519c0 0.257-0.209 0.466-0.466 0.466s-0.466-0.209-0.466-0.466v-0.519c-0.933-0.213-1.631-1.048-1.631-2.044 0-0.257 0.209-0.466 0.466-0.466s0.466 0.209 0.466 0.466c0 0.642 0.523 1.165 1.165 1.165s1.165-0.523 1.165-1.165c0-0.642-0.523-1.165-1.165-1.165-1.156 0-2.097-0.941-2.097-2.097 0-0.996 0.698-1.832 1.631-2.044v-0.519c0-0.257 0.209-0.466 0.466-0.466s0.466 0.209 0.466 0.466v0.519c0.933 0.213 1.631 1.048 1.631 2.044 0 0.257-0.209 0.466-0.466 0.466s-0.466-0.209-0.466-0.466c0-0.642-0.523-1.165-1.165-1.165s-1.165 0.523-1.165 1.165c0 0.642 0.523 1.165 1.165 1.165zM0.987 22.327l11.272 6.216v-12.265l-11.242-6.099c-0.010 4.049-0.020 8.098-0.031 12.148zM24.486 17.088v-4.571l-0.429-0.415c-0.087-0.084-0.206-0.123-0.325-0.106l-1.111 0.157c-0.055 0.008-0.111 0.012-0.165 0.012-0.337 0-0.647-0.146-0.86-0.388l-8.35 4.595v12.168l4.047-2.248c-0.135-0.566-0.205-1.152-0.205-1.748 0-1.992 0.776-3.864 2.184-5.272 1.395-1.395 3.244-2.169 5.214-2.184zM19.801 7.054l-0.923-0.51-11.166 6.145 5.126 2.781 8.421-4.635-0.128-0.728c-0.021-0.119-0.094-0.22-0.201-0.277l-0.991-0.526c-0.552-0.293-0.769-0.962-0.495-1.523l0.356-0.728zM31.030 8.632c0.187-0.099 0.26-0.325 0.167-0.515l-0.493-1.008c-0.157-0.321-0.157-0.69 0-1.011l0.493-1.008c0.093-0.19 0.019-0.416-0.167-0.515l-0.991-0.526c-0.316-0.168-0.533-0.466-0.594-0.818l-0.194-1.105c-0.036-0.208-0.229-0.348-0.438-0.318l-1.111 0.157c-0.354 0.050-0.705-0.064-0.962-0.313l-0.806-0.78c-0.152-0.147-0.39-0.147-0.542 0l-0.806 0.78c-0.257 0.249-0.608 0.363-0.962 0.313l-1.111-0.157c-0.209-0.030-0.402 0.11-0.438 0.318l-0.194 1.105c-0.062 0.352-0.278 0.65-0.594 0.818l-0.991 0.526c-0.187 0.099-0.26 0.325-0.167 0.515l0.493 1.008c0.157 0.321 0.157 0.69 0 1.011l-0.493 1.008c-0.093 0.19-0.019 0.416 0.167 0.515l0.991 0.526c0.316 0.168 0.533 0.466 0.594 0.818l0.194 1.105c0.037 0.208 0.229 0.348 0.438 0.318l1.111-0.157c0.055-0.008 0.11-0.012 0.164-0.012 0.296 0 0.58 0.114 0.798 0.324l0.806 0.78c0.152 0.147 0.39 0.147 0.542 0l0.806-0.78c0.257-0.249 0.608-0.363 0.962-0.312l1.111 0.157c0.209 0.030 0.402-0.11 0.438-0.318l0.194-1.105c0.062-0.352 0.279-0.65 0.594-0.818l0.991-0.526zM1.556 9.349l5.126 2.781 11.175-6.15-5.079-2.807-11.222 6.176zM27.187 7.239c-0.77 0-1.397 0.626-1.397 1.397s0.626 1.396 1.397 1.396c0.77 0 1.396-0.626 1.396-1.396s-0.626-1.397-1.396-1.397zM28.446 3.821c-0.149-0.149-0.39-0.149-0.539 0l-5.027 5.027c-0.149 0.149-0.149 0.39 0 0.539 0.074 0.074 0.172 0.112 0.269 0.112s0.195-0.037 0.269-0.112l5.027-5.027c0.149-0.149 0.149-0.39 0-0.539zM27.187 9.27c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635zM24.14 3.176c-0.77 0-1.397 0.626-1.397 1.396s0.627 1.397 1.397 1.397 1.397-0.626 1.397-1.397c0-0.77-0.627-1.396-1.397-1.396zM24.14 5.207c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635z"}),
	),
	"offer_product_variations": el("svg", { width: 30, height: 30, viewBox:"0 0 32 32"  },
		el("path", { fill: "#f16334", d:"M17.457 27.381l-4.471 2.431c-0.095 0.051-0.206 0.071-0.311 0.054-0.016-0.003-0.032-0.007-0.048-0.012l-0.010-0.001-0.017-0.009c-0.029-0.011-0.057-0.024-0.085-0.034l-12.26-6.76c-0.045-0.037-0.098-0.066-0.136-0.11-0.104-0.121-0.093-0.173-0.119-0.323l0.033-13.266 0.002-0.012c-0-0.040 0.005-0.082 0.017-0.124 0.034-0.119 0.067-0.19 0.236-0.295l12.226-6.728c0.063-0.031 0.085-0.062 0.246-0.060 0.053-0.006 0.073 0.001 0.097 0.002 0.085 0.014 0.106 0.021 0.183 0.059l6.654 3.745-0.25-0.512c-0.274-0.561-0.057-1.23 0.495-1.522l0.991-0.526c0.107-0.057 0.18-0.158 0.201-0.277l0.194-1.105c0.108-0.615 0.677-1.028 1.295-0.941l1.111 0.157c0.12 0.017 0.238-0.022 0.325-0.106l0.806-0.78c0.449-0.434 1.152-0.434 1.601 0l0.806 0.78c0.087 0.084 0.206 0.123 0.325 0.106l1.111-0.157c0.618-0.087 1.187 0.326 1.295 0.941l0.194 1.105c0.021 0.119 0.094 0.22 0.201 0.277l0.991 0.526c0.552 0.293 0.769 0.962 0.495 1.523l-0.493 1.008c-0.053 0.109-0.053 0.233 0 0.342l0.493 1.008c0.274 0.561 0.057 1.23-0.495 1.523l-0.991 0.526c-0.107 0.057-0.18 0.158-0.201 0.277l-0.194 1.105c-0.108 0.615-0.677 1.028-1.295 0.941l-1.111-0.157c-0.12-0.017-0.238 0.022-0.325 0.106l-0.806 0.78c-0.224 0.217-0.513 0.326-0.801 0.326-0.064 0-0.128-0.005-0.191-0.016v6.398l0.697-0.701c0.134-0.122 0.138-0.125 0.323-0.116 0.148 0.022 0.176 0.054 0.244 0.116l3.793 3.816c0.144 0.16 0.145 0.407-0.004 0.568l-2.598 2.547 0.341-0.018h3.353c0.013 0.001 0.026 0.001 0.039 0.002 0.199 0.029 0.351 0.194 0.361 0.398v5.396c-0.010 0.214-0.182 0.389-0.399 0.4l-10.891 0.022c-0.035-0.002-0.045-0.001-0.076-0.007-0.623 0.021-1.252-0.142-1.777-0.479-0.866-0.555-1.417-1.558-1.421-2.595v-1.557zM22.821 18.276h-4.564c0 3.559-0.011 7.117 0 10.676 0.009 0.968 0.701 1.903 1.643 2.177 0.762 0.222 1.636 0.010 2.211-0.538 0.446-0.425 0.707-1.033 0.709-1.654v-10.661zM31.221 26.601h-2.932l-1.082 0.056c-1.19 1.123-2.397 2.241-3.523 3.427-0.146 0.154-0.303 0.301-0.42 0.477-0.047 0.073-0.048 0.081-0.066 0.103-0.168 0.201-0.372 0.379-0.578 0.551l8.601-0.017v-4.597zM20.55 27.212c0.778 0.007 1.504 0.612 1.642 1.389 0.134 0.754-0.315 1.575-1.027 1.863-0.868 0.351-1.991-0.174-2.247-1.125-0.26-0.966 0.486-2.096 1.578-2.127 0.018-0 0.036-0 0.054-0zM20.533 28.012c-0.604 0.006-1.083 0.758-0.756 1.328 0.299 0.523 1.186 0.575 1.519 0.009 0.306-0.521-0.072-1.327-0.745-1.338-0.006 0-0.011 0-0.017 0zM23.754 22.454l-0.115 6.449 6.040-5.92-3.225-3.244c-0.9 0.905-1.799 1.81-2.699 2.715zM0.987 22.327l11.272 6.216v-12.265l-11.242-6.099c-0.010 4.049-0.020 8.098-0.031 12.148zM24.486 20.582v-8.065l-0.429-0.415c-0.087-0.084-0.206-0.123-0.325-0.106l-1.111 0.157c-0.055 0.008-0.111 0.012-0.165 0.012-0.337 0-0.647-0.146-0.86-0.388l-8.35 4.595v12.168l4.211-2.339v-8.325c0.012-0.213 0.181-0.388 0.4-0.4h5.364c0.015 0.001 0.030 0.002 0.045 0.003 0.195 0.033 0.344 0.193 0.355 0.397 0 1.191 0.001 2.383 0.002 3.574l0.862-0.868zM19.801 7.054l-0.923-0.51-11.166 6.145 5.126 2.781 8.421-4.635-0.128-0.728c-0.021-0.119-0.094-0.22-0.201-0.277l-0.991-0.526c-0.552-0.293-0.769-0.962-0.495-1.523l0.356-0.728zM31.030 8.632c0.187-0.099 0.26-0.325 0.167-0.515l-0.493-1.008c-0.157-0.321-0.157-0.69 0-1.011l0.493-1.008c0.093-0.19 0.019-0.416-0.167-0.515l-0.991-0.526c-0.316-0.168-0.533-0.466-0.594-0.818l-0.194-1.105c-0.036-0.208-0.229-0.348-0.438-0.318l-1.111 0.157c-0.354 0.050-0.705-0.064-0.962-0.313l-0.806-0.78c-0.152-0.147-0.39-0.147-0.542 0l-0.806 0.78c-0.257 0.249-0.608 0.363-0.962 0.313l-1.111-0.157c-0.209-0.030-0.402 0.11-0.438 0.318l-0.194 1.105c-0.062 0.352-0.278 0.65-0.594 0.818l-0.991 0.526c-0.187 0.099-0.26 0.325-0.167 0.515l0.493 1.008c0.157 0.321 0.157 0.69 0 1.011l-0.493 1.008c-0.093 0.19-0.019 0.416 0.167 0.515l0.991 0.526c0.316 0.168 0.533 0.466 0.594 0.818l0.194 1.105c0.037 0.208 0.229 0.348 0.438 0.318l1.111-0.157c0.055-0.008 0.11-0.012 0.164-0.012 0.296 0 0.58 0.114 0.798 0.324l0.806 0.78c0.152 0.147 0.39 0.147 0.542 0l0.806-0.78c0.257-0.249 0.608-0.363 0.962-0.312l1.111 0.157c0.209 0.030 0.402-0.11 0.438-0.318l0.194-1.105c0.062-0.352 0.279-0.65 0.594-0.818l0.991-0.526zM1.556 9.349l5.126 2.781 11.175-6.15-5.079-2.807-11.222 6.176zM27.187 7.239c-0.77 0-1.397 0.626-1.397 1.397s0.626 1.396 1.397 1.396c0.77 0 1.396-0.626 1.396-1.396s-0.626-1.397-1.396-1.397zM28.446 3.821c-0.149-0.149-0.39-0.149-0.539 0l-5.027 5.027c-0.149 0.149-0.149 0.39 0 0.539 0.074 0.074 0.172 0.112 0.269 0.112s0.195-0.037 0.269-0.112l5.027-5.027c0.149-0.149 0.149-0.39 0-0.539zM27.187 9.27c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635zM24.14 3.176c-0.77 0-1.397 0.626-1.397 1.396s0.627 1.397 1.397 1.397 1.397-0.626 1.397-1.397c0-0.77-0.627-1.396-1.397-1.396zM24.14 5.207c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635z"}),
	),
	"offer_product_image": el("svg", { width: 30, height: 30, viewBox:"0 0 32 32"  },
		el("path", { fill: "#f16334", d:"M14.81 28.8l-1.824 1.012c-0.095 0.051-0.206 0.071-0.311 0.054-0.016-0.003-0.032-0.007-0.048-0.012l-0.010-0.001-0.017-0.009c-0.029-0.011-0.057-0.024-0.085-0.034l-12.26-6.76c-0.045-0.037-0.098-0.066-0.136-0.11-0.104-0.121-0.093-0.173-0.119-0.323l0.033-13.266 0.002-0.012c-0-0.040 0.005-0.082 0.017-0.124 0.034-0.119 0.067-0.19 0.236-0.295l12.226-6.728c0.063-0.031 0.085-0.062 0.246-0.060 0.053-0.006 0.073 0.001 0.097 0.002 0.085 0.014 0.106 0.021 0.183 0.059l6.654 3.745-0.25-0.512c-0.274-0.561-0.057-1.23 0.495-1.522l0.991-0.526c0.107-0.057 0.18-0.158 0.201-0.277l0.194-1.105c0.108-0.615 0.677-1.028 1.295-0.941l1.111 0.157c0.12 0.017 0.238-0.022 0.325-0.106l0.806-0.78c0.449-0.434 1.152-0.434 1.601 0l0.806 0.78c0.087 0.084 0.206 0.123 0.325 0.106l1.111-0.157c0.618-0.087 1.187 0.326 1.295 0.941l0.194 1.105c0.021 0.119 0.094 0.22 0.201 0.277l0.991 0.526c0.552 0.293 0.769 0.962 0.495 1.523l-0.493 1.008c-0.053 0.109-0.053 0.233 0 0.342l0.493 1.008c0.274 0.561 0.057 1.23-0.495 1.523l-0.991 0.526c-0.107 0.057-0.18 0.158-0.201 0.277l-0.194 1.105c-0.108 0.615-0.677 1.028-1.295 0.941l-1.111-0.157c-0.12-0.017-0.238 0.022-0.325 0.106l-0.806 0.78c-0.224 0.217-0.513 0.326-0.801 0.326-0.064 0-0.128-0.005-0.191-0.016v6.579c0.306 0.040 0.598 0.176 0.827 0.392l1.386 1.331c0.809 0 1.618-0.084 2.355 0.19 1.141 0.424 1.964 1.574 1.976 2.824 0.005 1.492 0.005 2.985 0 4.477-0.015 1.56-1.355 2.998-3.014 3.014-3.726 0.012-7.452 0.012-11.178 0-1.525-0.014-2.94-1.292-3.011-2.897-0.002-0.039-0.003-0.078-0.003-0.117-0-0.062-0-0.124-0-0.186zM21.461 20.559c-0.155 0.001-0.307 0.056-0.425 0.156l-1.658 1.413c-0.121 0.070-0.122 0.071-0.259 0.096-0.675 0-1.372-0.087-1.976 0.113-0.878 0.29-1.523 1.165-1.532 2.106-0.005 1.513-0.005 3.025 0 4.538 0.011 1.152 0.994 2.207 2.219 2.219 3.723 0.012 7.445 0.012 11.168 0 1.153-0.011 2.207-0.994 2.219-2.219 0.005-1.489 0.005-2.978 0-4.467-0.011-1.158-1.026-2.216-2.234-2.219h-1.458c-0.148-0.029-0.15-0.030-0.277-0.112-0.502-0.483-1.001-0.968-1.507-1.448-0.119-0.11-0.277-0.174-0.439-0.176-1.28-0.008-2.56 0-3.84 0zM23.423 23.442c1.225 0.011 2.426 0.781 2.889 1.908 0.482 1.173 0.102 2.634-0.925 3.448-1.274 1.011-3.347 0.854-4.427-0.45-0.678-0.819-0.869-2.015-0.465-2.998 0.463-1.128 1.651-1.897 2.889-1.908 0.013 0 0.027 0 0.040 0zM23.388 24.242c-1.141 0.010-2.225 0.928-2.307 2.065-0.088 1.212 0.989 2.369 2.307 2.377 1.036 0.006 2.051-0.722 2.288-1.736 0.159-0.682-0.048-1.435-0.525-1.952-0.445-0.481-1.088-0.756-1.762-0.754zM0.987 22.327l11.272 6.216v-12.265l-11.242-6.099c-0.010 4.049-0.020 8.098-0.031 12.148zM24.486 19.755v-7.238l-0.429-0.415c-0.087-0.084-0.206-0.123-0.325-0.106l-1.111 0.157c-0.055 0.008-0.111 0.012-0.165 0.012-0.337 0-0.647-0.146-0.86-0.388l-8.35 4.595v12.168l1.562-0.868c-0.002-1.078-0-2.157 0.003-3.235 0.015-1.561 1.348-3.009 3.033-3.014h1.128l1.548-1.319c0.059-0.050 0.068-0.055 0.101-0.079 0.239-0.17 0.529-0.263 0.824-0.268 1.014-0.006 2.028-0.007 3.042-0.004zM29.588 24.419c0.057-0.001 0.113-0.012 0.164-0.035 0.379-0.17 0.198-0.745-0.148-0.765-0.497-0.010-0.993-0-1.49-0-0.128 0.002-0.254 0.065-0.327 0.17-0.179 0.254 0.035 0.624 0.327 0.63h1.475zM19.801 7.054l-0.923-0.51-11.166 6.145 5.126 2.781 8.421-4.635-0.128-0.728c-0.021-0.119-0.094-0.22-0.201-0.277l-0.991-0.526c-0.552-0.293-0.769-0.962-0.495-1.523l0.356-0.728zM31.030 8.632c0.187-0.099 0.26-0.325 0.167-0.515l-0.493-1.008c-0.157-0.321-0.157-0.69 0-1.011l0.493-1.008c0.093-0.19 0.019-0.416-0.167-0.515l-0.991-0.526c-0.316-0.168-0.533-0.466-0.594-0.818l-0.194-1.105c-0.036-0.208-0.229-0.348-0.438-0.318l-1.111 0.157c-0.354 0.050-0.705-0.064-0.962-0.313l-0.806-0.78c-0.152-0.147-0.39-0.147-0.542 0l-0.806 0.78c-0.257 0.249-0.608 0.363-0.962 0.313l-1.111-0.157c-0.209-0.030-0.402 0.11-0.438 0.318l-0.194 1.105c-0.062 0.352-0.278 0.65-0.594 0.818l-0.991 0.526c-0.187 0.099-0.26 0.325-0.167 0.515l0.493 1.008c0.157 0.321 0.157 0.69 0 1.011l-0.493 1.008c-0.093 0.19-0.019 0.416 0.167 0.515l0.991 0.526c0.316 0.168 0.533 0.466 0.594 0.818l0.194 1.105c0.037 0.208 0.229 0.348 0.438 0.318l1.111-0.157c0.055-0.008 0.11-0.012 0.164-0.012 0.296 0 0.58 0.114 0.798 0.324l0.806 0.78c0.152 0.147 0.39 0.147 0.542 0l0.806-0.78c0.257-0.249 0.608-0.363 0.962-0.312l1.111 0.157c0.209 0.030 0.402-0.11 0.438-0.318l0.194-1.105c0.062-0.352 0.279-0.65 0.594-0.818l0.991-0.526zM1.556 9.349l5.126 2.781 11.175-6.15-5.079-2.807-11.222 6.176zM27.187 7.239c-0.77 0-1.397 0.626-1.397 1.397s0.626 1.396 1.397 1.396c0.77 0 1.396-0.626 1.396-1.396s-0.626-1.397-1.396-1.397zM28.446 3.821c-0.149-0.149-0.39-0.149-0.539 0l-5.027 5.027c-0.149 0.149-0.149 0.39 0 0.539 0.074 0.074 0.172 0.112 0.269 0.112s0.195-0.037 0.269-0.112l5.027-5.027c0.149-0.149 0.149-0.39 0-0.539zM27.187 9.27c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635zM24.14 3.176c-0.77 0-1.397 0.626-1.397 1.396s0.627 1.397 1.397 1.397 1.397-0.626 1.397-1.397c0-0.77-0.627-1.396-1.397-1.396zM24.14 5.207c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635z"}),
	),
	"offer_product_quantity": el("svg", { width: 30, height: 30, viewBox:"0 0 32 32"  },
		el("path", { fill: "#f16334", d:"M16.609 27.061l-3.623 2.751c-0.095 0.051-0.206 0.071-0.311 0.054-0.016-0.003-0.032-0.007-0.048-0.012l-0.010-0.001-0.017-0.009c-0.029-0.011-0.057-0.024-0.085-0.034l-12.26-6.76c-0.045-0.037-0.098-0.066-0.136-0.11-0.104-0.121-0.093-0.173-0.119-0.323l0.033-13.266 0.002-0.012c-0-0.040 0.005-0.082 0.017-0.124 0.034-0.119 0.067-0.19 0.236-0.295l12.226-6.728c0.063-0.031 0.085-0.062 0.246-0.060 0.053-0.006 0.073 0.001 0.097 0.002 0.085 0.014 0.106 0.021 0.183 0.059l6.654 3.745-0.25-0.512c-0.274-0.561-0.057-1.23 0.495-1.522l0.991-0.526c0.107-0.057 0.18-0.158 0.201-0.277l0.194-1.105c0.108-0.615 0.677-1.028 1.295-0.941l1.111 0.157c0.12 0.017 0.238-0.022 0.325-0.106l0.806-0.78c0.449-0.434 1.152-0.434 1.601 0l0.806 0.78c0.087 0.084 0.206 0.123 0.325 0.106l1.111-0.157c0.618-0.087 1.187 0.326 1.295 0.941l0.194 1.105c0.021 0.119 0.094 0.22 0.201 0.277l0.991 0.526c0.552 0.293 0.769 0.962 0.495 1.523l-0.493 1.008c-0.053 0.109-0.053 0.233 0 0.342l0.493 1.008c0.274 0.561 0.057 1.23-0.495 1.523l-0.991 0.526c-0.107 0.057-0.18 0.158-0.201 0.277l-0.194 1.105c-0.108 0.615-0.677 1.028-1.295 0.941l-1.111-0.157c-0.12-0.017-0.238 0.022-0.325 0.106l-0.806 0.78c-0.224 0.217-0.513 0.326-0.801 0.326-0.064 0-0.128-0.005-0.191-0.016v2.944c1.093 0.204 2.11 0.632 2.998 1.233 1.277 0.863 2.291 2.084 2.9 3.52 0.406 0.957 0.63 2.010 0.63 3.112 0 1.653-0.505 3.194-1.368 4.471s-2.084 2.291-3.52 2.899c-0.957 0.406-2.010 0.63-3.112 0.63-1.653 0-3.194-0.505-4.47-1.368s-2.291-2.084-2.9-3.52c-0.007-0.017-0.014-0.034-0.021-0.050zM30.388 26.696c0.351-0.829 0.545-1.739 0.545-2.696-0-1.435-0.437-2.765-1.186-3.873s-1.809-1.988-3.052-2.515c-0.829-0.351-1.739-0.545-2.695-0.545-1.435 0-2.765 0.437-3.873 1.185s-1.988 1.809-2.515 3.052c-0.351 0.829-0.545 1.739-0.545 2.696 0 1.435 0.437 2.765 1.186 3.873s1.809 1.988 3.052 2.515c0.829 0.351 1.739 0.545 2.695 0.546 1.435-0 2.765-0.437 3.873-1.185s1.988-1.809 2.515-3.052zM0.987 22.327l11.272 6.216v-12.265l-11.242-6.099c-0.010 4.049-0.020 8.098-0.031 12.148zM24.486 16.015v-3.498l-0.429-0.415c-0.087-0.084-0.206-0.123-0.325-0.106l-1.111 0.157c-0.055 0.008-0.111 0.012-0.165 0.012-0.337 0-0.647-0.146-0.86-0.388l-8.35 4.595v12.168l3.055-2.364c-0.196-0.693-0.301-1.423-0.301-2.176-0-1.653 0.505-3.194 1.368-4.471s2.084-2.291 3.52-2.899c0.957-0.406 2.010-0.63 3.112-0.63 0.163 0 0.325 0.005 0.486 0.015zM27.321 20.679c0.204 0.204 0.204 0.534 0 0.738l-5.904 5.904c-0.204 0.204-0.534 0.204-0.738 0s-0.204-0.534 0-0.738l5.904-5.904c0.204-0.204 0.534-0.204 0.738 0zM28.175 27.305c0.288 0 0.522-0.234 0.522-0.522s-0.234-0.522-0.522-0.522h-3.479c-0.288 0-0.522 0.234-0.522 0.522s0.234 0.522 0.522 0.522h3.479zM22.434 21.739h1.218c0.288 0 0.522-0.234 0.522-0.522s-0.234-0.522-0.522-0.522h-1.218v-1.218c0-0.288-0.234-0.522-0.522-0.522s-0.522 0.234-0.522 0.522v1.218h-1.218c-0.288 0-0.522 0.234-0.522 0.522s0.234 0.522 0.522 0.522h1.218v1.218c0 0.288 0.234 0.522 0.522 0.522s0.522-0.234 0.522-0.522v-1.218zM19.801 7.054l-0.923-0.51-11.166 6.145 5.126 2.781 8.421-4.635-0.128-0.728c-0.021-0.119-0.094-0.22-0.201-0.277l-0.991-0.526c-0.552-0.293-0.769-0.962-0.495-1.523l0.356-0.728zM31.030 8.632c0.187-0.099 0.26-0.325 0.167-0.515l-0.493-1.008c-0.157-0.321-0.157-0.69 0-1.011l0.493-1.008c0.093-0.19 0.019-0.416-0.167-0.515l-0.991-0.526c-0.316-0.168-0.533-0.466-0.594-0.818l-0.194-1.105c-0.036-0.208-0.229-0.348-0.438-0.318l-1.111 0.157c-0.354 0.050-0.705-0.064-0.962-0.313l-0.806-0.78c-0.152-0.147-0.39-0.147-0.542 0l-0.806 0.78c-0.257 0.249-0.608 0.363-0.962 0.313l-1.111-0.157c-0.209-0.030-0.402 0.11-0.438 0.318l-0.194 1.105c-0.062 0.352-0.278 0.65-0.594 0.818l-0.991 0.526c-0.187 0.099-0.26 0.325-0.167 0.515l0.493 1.008c0.157 0.321 0.157 0.69 0 1.011l-0.493 1.008c-0.093 0.19-0.019 0.416 0.167 0.515l0.991 0.526c0.316 0.168 0.533 0.466 0.594 0.818l0.194 1.105c0.037 0.208 0.229 0.348 0.438 0.318l1.111-0.157c0.055-0.008 0.11-0.012 0.164-0.012 0.296 0 0.58 0.114 0.798 0.324l0.806 0.78c0.152 0.147 0.39 0.147 0.542 0l0.806-0.78c0.257-0.249 0.608-0.363 0.962-0.312l1.111 0.157c0.209 0.030 0.402-0.11 0.438-0.318l0.194-1.105c0.062-0.352 0.279-0.65 0.594-0.818l0.991-0.526zM1.556 9.349l5.126 2.781 11.175-6.15-5.079-2.807-11.222 6.176zM27.187 7.239c-0.77 0-1.397 0.626-1.397 1.397s0.626 1.396 1.397 1.396c0.77 0 1.396-0.626 1.396-1.396s-0.626-1.397-1.396-1.397zM28.446 3.821c-0.149-0.149-0.39-0.149-0.539 0l-5.027 5.027c-0.149 0.149-0.149 0.39 0 0.539 0.074 0.074 0.172 0.112 0.269 0.112s0.195-0.037 0.269-0.112l5.027-5.027c0.149-0.149 0.149-0.39 0-0.539zM27.187 9.27c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635zM24.14 3.176c-0.77 0-1.397 0.626-1.397 1.396s0.627 1.397 1.397 1.397 1.397-0.626 1.397-1.397c0-0.77-0.627-1.396-1.397-1.396zM24.14 5.207c-0.35 0-0.635-0.285-0.635-0.635s0.285-0.635 0.635-0.635c0.35 0 0.635 0.285 0.635 0.635s-0.285 0.635-0.635 0.635z"}),
	),
	"logo": el("svg", { width: 20, height: 20, viewBox:"0 0 32 32" },
		el("path", { fill: "none", stroke:"#f16334", d: "M30.597 16c0 8.062-6.535 14.597-14.597 14.597s-14.597-6.535-14.597-14.597c0-8.062 6.535-14.597 14.597-14.597s14.597 6.535 14.597 14.597z" } ),
		el( "path", { fill: "#f16334", stroke:"#f16334", d: "M16.338 21.101c-0.751 0-1.358 0.607-1.358 1.358s0.607 1.36 1.358 1.36c0.753 0 1.36-0.61 1.36-1.36-0-0.75-0.607-1.357-1.36-1.357zM12.26 21.101c-0.75 0-1.36 0.607-1.36 1.358s0.609 1.36 1.36 1.36c0.751 0 1.361-0.61 1.361-1.36 0-0.75-0.61-1.357-1.361-1.357zM23.819 8.182c-0.078 0.726-0.412 1.373-0.906 1.855-0.551 0.538-1.305 0.867-2.134 0.867h-0.681c-0.186 0-0.339 0.15-0.339 0.339v1.021h2.72c0 1.502-1.217 2.719-2.72 2.719v1.36c0 1.776-1.136 3.286-2.719 3.845-0.22 0.077-0.448 0.141-0.681 0.176-0.221 0.041-0.447 0.061-0.68 0.061h-3.419c-0.23 0-0.458-0.020-0.68-0.061-0.233-0.035-0.461-0.099-0.679-0.176-1.583-0.558-2.719-2.069-2.719-3.845 0-2.020 1.47-3.699 3.398-4.025 0.223-0.036 0.45-0.055 0.68-0.055h3.748v2.719h-3.748c-0.749 0-1.36 0.611-1.36 1.36s0.61 1.36 1.36 1.36h3.419c0.749 0 1.36-0.611 1.36-1.36v-5.1c0-0.861 0.355-1.636 0.927-2.194 0.551-0.535 1.305-0.866 2.132-0.866h3.721z" } )
	),
	"top_margin": el("svg", { width: 20, height: 20 },
		el("path", { fill: "#999", d: "M17 1c1.103 0 2 0.897 2 2v14c0 1.103-0.897 2-2 2h-14c-1.103 0-2-0.897-2-2v-14c0-1.103 0.897-2 2-2h14zM17 0h-14c-1.657 0-3 1.343-3 3v14c0 1.657 1.343 3 3 3h14c1.657 0 3-1.343 3-3v-14c0-1.657-1.343-3-3-3v0z" } ),
		el( "path", { fill: "#575E67", d: "M17 0.984h-14c-1.103 0-2 0.897-2 2v0.797h18v-0.797c0-1.103-0.897-2-2-2z" } )
	),
	"bottom_margin": el("svg", { width: 20, height: 20 },
		el("path", { fill: "#999", d: "M17 1c1.103 0 2 0.897 2 2v14c0 1.103-0.897 2-2 2h-14c-1.103 0-2-0.897-2-2v-14c0-1.103 0.897-2 2-2h14zM17 0h-14c-1.657 0-3 1.343-3 3v14c0 1.656 1.343 3 3 3h14c1.657 0 3-1.343 3-3v-14c0-1.657-1.343-3-3-3v0z" } ),
		el( "path", { fill: "#575E67", d: "M3 19.016h14c1.103 0 2-0.896 2-2v-0.797h-18v0.797c0 1.103 0.897 2 2 2z" } )
	),
}

export default CFP_Block_Icons