<?php
// @codingStandardsIgnoreStart
if ( ! defined( 'FW' ) ) die( 'Forbidden' );

$c = apply_filters(
	'goto_tour_price_unit',
	array(
	    'USD' => 'US Dollars ($)',
	    'AED' => 'United Arab Emirates Dirham (د.إ)',
	    'AUD' => 'Australian Dollars ($)',
	    'BDT' => 'Bangladeshi Taka (৳)',
	    'BRL' => 'Brazilian Real (R$)',
	    'BGN' => 'Bulgarian Lev (лв.)',
	    'CAD' => 'Canadian Dollars ($)',
	    'CLP' => 'Chilean Peso ($)',
	    'CNY' => 'Chinese Yuan (¥)',
	    'COP' => 'Colombian Peso ($)',
	    'CZK' => 'Czech Koruna (Kč)',
	    'DKK' => 'Danish Krone (kr.)',
	    'DOP' => 'Dominican Peso (RD$)',
	    'EUR' => 'Euros (€)',
	    'HKD' => 'Hong Kong Dollar ($)',
	    'HRK' => 'Croatia kuna (Kn)',
	    'HUF' => 'Hungarian Forint (Ft)',
	    'ISK' => 'Icelandic krona (Kr.)',
	    'IDR' => 'Indonesia Rupiah (Rp)',
	    'INR' => 'Indian Rupee (Rs.)',
	    'NPR' => 'Nepali Rupee (Rs.)',
	    'ILS' => 'Israeli Shekel (₪)',
	    'JPY' => 'Japanese Yen (¥)',
	    'KIP' => 'Lao Kip (₭)',
	    'KRW' => 'South Korean Won (₩)',
	    'MYR' => 'Malaysian Ringgits (RM)',
	    'MXN' => 'Mexican Peso ($)',
	    'NGN' => 'Nigerian Naira (₦)',
	    'NOK' => 'Norwegian Krone (kr)',
	    'NZD' => 'New Zealand Dollar ($)',
	    'PYG' => 'Paraguayan Guaraní (₲)',
	    'PHP' => 'Philippine Pesos (₱)',
	    'PLN' => 'Polish Zloty (zł)',
	    'GBP' => 'Pounds Sterling (£)',
	    'RON' => 'Romanian Leu (lei)',
	    'RUB' => 'Russian Ruble (руб.)',
	    'SGD' => 'Singapore Dollar ($)',
	    'ZAR' => 'South African rand (R)',
	    'SEK' => 'Swedish Krona (kr)',
	    'CHF' => 'Swiss Franc (CHF)',
	    'TWD' => 'Taiwan New Dollars (NT$)',
	    'THB' => 'Thai Baht (฿)',
	    'TRY' => 'Turkish Lira (₺)',
	    'VND' => 'Vietnamese Dong (₫)',
	    'EGP' => 'Egyptian Pound (EGP)'
	)
);

$options = array(
    'box' => array(
        'type'    => 'box',
        'title'   => false,
        'options' => array(
            'unit'      => array(
                'label'   => esc_html__( 'Price unit', 'goto' ),
                'type'    => 'select',
                'choices' => $c,
                'value'   => 'USD'
            ),
        )
    )
);

if( defined( 'WPCF7_PLUGIN' ) ){
    $args = array(
        'post_type'      => 'wpcf7_contact_form',
        'posts_per_page' => -1,
    );

    $data = get_posts( $args );
    $dropdown_data = array();

    if( $data ){
        $dropdown_data[0] = esc_html__( 'Select your contact form', 'goto' );
        foreach( $data as $key ){
            $dropdown_data[$key->ID] = $key->post_title;
        }
    }else{
        $dropdown_data[0] = esc_html__( 'No contact form found', 'goto' );
    }

    $options['box']['options']['ctf7'] = array(
        'label'   => esc_html__( 'Contact form 7', 'goto' ),
        'type'    => 'select',
        'choices' => $dropdown_data,
        'value'   => 0
    );
}