<?php

namespace Elementor;

class goto_landing extends Widget_Base {

    public function get_categories() {
        return array( 'goto-theme' );
    }

    public function get_name() {
        return 'theme-landing';
    }

    public function get_title() {
        return esc_html__( 'Landing image', 'goto' );
    }

    public function get_icon() {
        return 'eicon-image-rollover';
    }

    protected function _register_controls() {
        $this->start_controls_section( 'section_landing', array(
            'label' =>  esc_html__( 'Image', 'goto' ),
        ));

        $this->add_control(
            'img', array(
                'label'   =>  esc_html__( 'Image', 'goto' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => array(
                    'url' => Utils::get_placeholder_image_src(),
                )
            )
        );

        $this->add_control(
            'url', array(
                'label'       =>  esc_html__( 'Url', 'goto' ),
                'type'        => Controls_Manager::URL,
                'placeholder' => esc_html__( 'http://your-url.com/', 'goto' ),
            )
        );

        $this->add_control(
            'title', array(
                'label'       =>  esc_html__( 'Title', 'goto' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'Your title', 'goto' ),
                'placeholder' => esc_html__( 'Enter the title', 'goto' ),
            )
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            array(
                'name'     => 'landing_title_typo',
                'label'    =>  esc_html__( 'Title typograpgy', 'goto' ),
                'selector' => '{{WRAPPER}} .landing-title',
                'scheme'   => Scheme_Typography::TYPOGRAPHY_2,
            )
        );

        $this->add_control(
            'btn', array(
                'label'       =>  esc_html__( 'Button', 'goto' ),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__( 'View demo', 'goto' ),
                'placeholder' => esc_html__( 'Button label', 'goto' ),
            )
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $img      = $settings['img'];
        $img_alt  = goto_img_alt( $img['id'], esc_attr__( 'Landing image', 'goto' ) );

        $href = '#';
        $attr = '';
        if( ! empty( $settings['url']['url'] ) ){
            $href = $settings['url']['url'];
            if( 'on' == $settings['url']['is_external'] ){
                $attr .= ' target="_blank"';
            }
            if( 'on' == $settings['url']['nofollow'] ){
                $attr .= ' rel="nofollow"';
            }
        }
        ?>
        <div class="goto-landing-image">
            <div class="landing-item">
                <a class="landing-item-url" href="<?php echo esc_url( $href ); ?>" <?php echo wp_kses_post( $attr ); ?>>
                    <span class="landing-btn"><?php echo esc_html( $settings['btn'] ); ?></span>
                </a>
                <img src="<?php echo esc_url( $img['url'] ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
            </div>
            <h2 class="landing-title text-center">
                <a href="<?php echo esc_url( $href ); ?>" <?php echo wp_kses_post( $attr ); ?>><?php echo esc_html( $settings['title'] ); ?></a>
            </h2>
        </div>
    <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new goto_landing() );