<?php
// @codingStandardsIgnoreStart
/* THEME STYLE AND SCRIPT
***************************************************/

add_action( 'wp_enqueue_scripts', 'goto_static' );
function goto_static(){
    /*MAIN STYLESHEET*/
    wp_enqueue_style(
        'goto-theme-style',
        get_stylesheet_uri()
    );

    /*COMMENT REPLY SCRIPT*/
    if( is_singular() && comments_open() && get_option( 'thread_comments' ) ){
        wp_enqueue_script( 'comment-reply' );
    }

    /*TINY SLIDER*/
    wp_register_script(
        'tiny-slider-js',
        get_template_directory_uri() . '/js/tiny-slider.js',
        array(),
        null,
        true
    );

    wp_register_style(
        'tiny-slider',
        get_template_directory_uri() . '/css/tiny-slider.css'
    );

    /*DATE PICKER*/
    wp_register_script(
        'datepicker-js',
        get_template_directory_uri() . '/js/datepicker.js',
        array(),
        null,
        true
    );

    /*TOUR SINGLE SIDEBAR STICK*/
    wp_register_script(
        'sticky-sidebar-js',
        get_template_directory_uri() . '/js/sticky-sidebar.js',
        array(),
        null,
        true
    );

    /*TOUR LIST*/
    wp_register_script(
        'omni-slider-js',
        get_template_directory_uri() . '/js/omni-slider.js',
        array(),
        null,
        true
    );
    wp_register_script(
        'polyfill-ie-js',
        get_template_directory_uri() . '/js/array-find-ie.js',
        array(),
        null,
        true
    );
    wp_register_script(
        'goto-tour-list',
        get_template_directory_uri() . '/js/tour-list.js',
        array(),
        null,
        true
    );
    wp_register_script(
    	'goto-tour-booking',
	    get_template_directory_uri() . '/js/tour-booking.js',
	    array( 'jquery' ),
	    null,
	    true
    );

    /*LITY: VIDEO LIGHTBOX*/
    wp_register_style(
        'lity',
        get_template_directory_uri() . '/css/lity.css'
    );

    wp_register_script(
        'jquery-lity',
        get_template_directory_uri() . '/js/lity.js',
        array(),
        null,
        true
    );

    /*PHOTOSWIPE LIGHTBOX*/
    wp_register_style(
        'pswp-lightbox',
        get_template_directory_uri() . '/css/photoswipe.css'
    );
    wp_register_script(
        'jquery-pswp-global',
        get_template_directory_uri() . '/js/photoswipe-global.js',
        array(),
        null,
        true
    );

    wp_register_script(
        'jquery-photoswipe',
        get_template_directory_uri() . '/js/photoswipe.js',
        array(),
        null,
        true
    );

    wp_register_script(
        'jquery-pswp-ui',
        get_template_directory_uri() . '/js/photoswipe-ui-default.js',
        array(),
        null,
        true
    );

    /*COUNTDOWN*/
    wp_register_script(
        'jDoom-js',
        get_template_directory_uri() . '/js/countdown.js',
        array(),
        null,
        true
    );

    /*PLYR*/
    wp_register_script(
        'plyr-js',
        get_template_directory_uri() . '/js/plyr.js',
        array(),
        null,
        true
    );

    /*MOBILE MENU*/
    wp_enqueue_script(
        'goto-menu',
        get_template_directory_uri() . '/js/slim-menu-modified.js',
        array( 'jquery' ),
        null,
        true
    );

    /*SMOOTH SCROLL*/
    if( true == get_theme_mod( 'smooth', false ) ){
        wp_enqueue_script(
            'smoothscroll.js',
            get_template_directory_uri() . '/js/smoothscroll.js',
            array(),
            null,
            true
        );
    }

	// Tour single.
	wp_register_script(
        'goto-tour-single',
        get_template_directory_uri() . '/js/tour-single.js',
        array( 'jquery', 'sticky-sidebar-js' ),
        null,
        true
    );

    /*CUSTOM SCRIPT*/
    wp_enqueue_script(
        'goto-custom-script',
        get_template_directory_uri() . '/js/custom.js',
        array( 'jquery' ),
        null,
        true
    );
}

/* REGISTER JS FILE IN PREVIEW MODE
***************************************************/
add_action( 'elementor/frontend/after_register_scripts', 'goto_register_script_file' );
function goto_register_script_file(){
    wp_register_script(
        'tiny-slider-js',
        get_template_directory_uri() . '/js/tiny-slider.js',
        array(),
        null,
        true
    );

    wp_register_script(
        'jDoom-js',
        get_template_directory_uri() . '/js/countdown.js',
        array(),
        null,
        true
    );
}

/* SCRIPTS FOR WIDGET IN PREVIEW MODE
***************************************************/
add_action( 'elementor/preview/enqueue_scripts', 'goto_scripts_in_preview_mode' );
function goto_scripts_in_preview_mode(){
    wp_enqueue_script(
        'goto-elementor-preview',
        get_template_directory_uri() . '/js/elementor-preview.js',
        array(),
        null,
        true
    );
}

/* ENUQEUE CSS FILE IN PREVIEW MODE
***************************************************/
add_action( 'elementor/preview/enqueue_styles', 'goto_enqueue_style_file' );
function goto_enqueue_style_file(){
    wp_enqueue_style(
        'tiny-slider',
        get_template_directory_uri() . '/css/tiny-slider.css'
    );
};


/* ADMIN: TOUR SINGLE CUSTOM SCRIPT
***************************************************/
add_action( 'admin_enqueue_scripts', 'goto_admin_static' );
function goto_admin_static(){
    wp_register_script(
        'goto-tour-custom-js',
        get_template_directory_uri() .'/js/tour-customize.js',
        array( 'fw' ),
        null,
        true
    );
}


/* REQUIRED THEME FILE
***************************************************/

/*THEME INCLUDES*/
require_once get_template_directory() .'/inc/init.php';

/*TGM PLUGIN*/
require_once get_template_directory() . '/tgm-plugin/recommend_plugins.php';

/*KIRKI PLUGIN*/
require get_template_directory() . '/inc/kirki-fallback.php';

/*CUSTOMIZE*/
require get_template_directory() . '/inc/customizer.php';

/*ELEMENTOR*/
require get_template_directory() . '/inc/elementor.php';

