<?php

/* ADD FOOTER SECTION
***************************************************/
Goto_Kirki::add_section( 'footer', array(
    'title'      => esc_attr__( 'Footer', 'goto' ),
    'capability' => 'edit_theme_options',
    'priority'   => 1,
));


/*! footer widget
------------------------------------------------->*/
if( is_active_sidebar( 'footer-widget' ) ):
    /*column*/
    Goto_Kirki::add_field( 'goto', array(
        'type'      => 'select',
        'label'     => esc_attr__( 'Column', 'goto' ),
        'settings'  => 'ft_column',
        'section'   => 'footer',
        'default'   => '4',
        'transport' => 'postMessage',
        'choices'   => array(
            '1' => 1,
            '2' => 2,
            '3' => 3,
            '4' => 4,
            '5' => 5,
            '6' => 6,
        ),
    ));

    /*text-block*/
    Goto_Kirki::add_field( 'goto', array(
        'type'      => 'editor',
        'label'     => esc_attr__( 'Call to action footer', 'goto' ),
        'settings'  => 'ft_textblock',
        'section'   => 'footer',
        'transport' => 'postMessage',
        'js_vars'   => array(
            array(
                'element'  => '.widget-box .footer-cta',
                'function' => 'html',
            ),
        ),
    ));
endif;

/*! TEXT COLOR
------------------------------------------------->*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'color',
    'settings'  => 'footer_text',
    'section'   => 'footer',
    'label'     => esc_attr__( 'Text color', 'goto' ),
    'transport' => 'auto',
    'default'   => 'rgba(255, 255, 255, 0.8)',
    'output'    => array(
        array(
            'element' => array(
                '.theme-footer',
                '.theme-footer .widget-title',
                '.theme-footer a'
            ),
            'property' => 'color'
        )
    ),
));

/*! footer background
------------------------------------------------->*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'background',
    'settings'  => 'footer_bg',
    'section'   => 'footer',
    'transport' => 'auto',
    'default'   => array(
        'background-color'      => '#222',
        'background-image'      => '',
        'background-repeat'     => 'no-repeat',
        'background-position'   => 'center center',
        'background-size'       => 'cover',
        'background-attachment' => 'scroll',
    ),
    'output' => array(
        array(
            'element' => '.theme-footer'
        ),
        array(
            'element'  => '.theme-footer-menu .sub-menu',
            'choice'   => 'background-color',
            'property' => 'background-color'
        )
    ),
));

/*logo*/
Goto_Kirki::add_field( 'goto', array(
    'type'            => 'image',
    'settings'        => 'ft_logo',
    'section'         => 'footer',
    'label'           => esc_attr__( 'Logo', 'goto' ),
    'partial_refresh' => array(
        'footer_logo' => array(
            'selector'        => '.footer-logo-wr',
            'render_callback' => 'goto_footer_logo',
        ),
    ),
    'partial_refresh' => array(
        'footer_edit_location' => array(
            'selector'        => '#footer-edit-location',
            'render_callback' => 'goto_edit_location',
        ),
    ),
));

/*copyright text*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'editor',
    'label'     => esc_attr__( 'Copyright text', 'goto' ),
    'settings'  => 'ft_copy',
    'section'   => 'footer',
    'transport' => 'postMessage',
    'js_vars'   => array(
        array(
            'element'  => '.footer-content-copyright',
            'function' => 'html',
        ),
    ),
));

/*right content*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'textarea',
    'label'     => esc_attr__( 'Right footer content', 'goto' ),
    'settings'  => 'ft_right',
    'section'   => 'footer',
    'transport' => 'postMessage',
    'js_vars'   => array(
        array(
            'element'  => '.footer-right',
            'function' => 'html',
        ),
    ),
));