<?php

/* ADD GENERAL SECTION
***************************************************/
Goto_Kirki::add_section( 'c_general', array(
    'title'    => esc_attr__( 'General', 'goto' ),
    'priority' => 0,
));




/*header layout*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'radio-buttonset',
    'settings'    => 'header_layout_cfg',
    'label'       => esc_attr__( 'Menu Layout', 'goto' ),
    'section'     => 'c_general',
    'default'     => 'layout-1',
    'description' => esc_attr__( 'Choose Menu Preset Select your main header preset here to apply for all pages', 'goto' ),
    'choices'     => array(
		'layout-1' => esc_attr__( 'Layout 1', 'goto' ),
		'layout-2' => esc_attr__( 'Layout 2', 'goto' ),
        'layout-3' => esc_attr__( 'Layout 3', 'goto' ),
	),
    'partial_refresh' => array(
        'menu_layout' => array(
            'selector'        => 'body:not(.single-ht_tour):not(.group-blog) #theme-menu-layout',
            'render_callback' => 'goto_menu_layout',
        ),
    ),
));

/*loading effect*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'switch',
    'settings'    => 'loading',
    'label'       => esc_attr__( 'Preloader', 'goto' ),
    'section'     => 'c_general',
    'default'     => false,
    'description' => esc_attr__( 'This option showing a loading animation while your site loads', 'goto' ),
    'choices'     => array(
        'off' => esc_attr__( 'Off', 'goto' ),
        'on'  => esc_attr__( 'On', 'goto' ),
	)
));

/*smooth scroll*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'switch',
    'settings'    => 'smooth',
    'label'       => esc_attr__( 'Smooth scrolling', 'goto' ),
    'section'     => 'c_general',
    'default'     => false,
    'description' => esc_attr__( 'Smooth scrolling for the web', 'goto' ),
    'choices'     => array(
        'off' => esc_attr__( 'Off', 'goto' ),
        'on'  => esc_attr__( 'On', 'goto' ),
	)
));

/*searching*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'switch',
    'settings'    => 'search',
    'label'       => esc_attr__( 'Dialog search', 'goto' ),
    'section'     => 'c_general',
    'default'     => false,
    'description' => esc_attr__( 'Search only Tours or Destinations', 'goto' ),
    'choices'     => array(
        'off' => esc_attr__( 'Off', 'goto' ),
        'on'  => esc_attr__( 'On', 'goto' ),
    )
));