<?php

/* ADD HEADER LAYOUT PANEL
***************************************************/
Goto_Kirki::add_panel( 'c_panel', array(
    'title'    => esc_attr__( 'Header Layout', 'goto'),
    'priority' => 1,
));

/* ADD HEADER LAYOUT 1 SECTION
***************************************************/
Goto_Kirki::add_section( 'header_1', array(
    'title' => esc_attr__( 'Layout 1', 'goto'),
    'panel' => 'c_panel',
));

/* ADD HEADER LAYOUT 2 SECTION
***************************************************/
Goto_Kirki::add_section( 'header_2', array(
    'title' => esc_attr__( 'Layout 2', 'goto'),
    'panel' => 'c_panel',
));

/* ADD HEADER LAYOUT 3 SECTION
***************************************************/
Goto_Kirki::add_section( 'header_3', array(
    'title' => esc_attr__( 'Layout 3', 'goto'),
    'panel' => 'c_panel',
));




/* HEADER LAYOUT 1
***************************************************/

/*background menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'color',
    'settings'  => 'c_menu_bg',
    'section'   => 'header_1',
    'label'     => esc_attr__( 'Menu background', 'goto' ),
    'transport' => 'auto',
    'default'   => '#fff',
    'choices'   => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'     => '.header-layout-1 .header-box',
            'property'    => 'background-color',
            'media_query' => '@media ( min-width: 992px )'
        )
    ),
    'partial_refresh' => array(
        'hd1_edit_location' => array(
            'selector'        => '#hd1-edit-location',
            'render_callback' => 'goto_edit_location',
        ),
    ),
));


/*highlight menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'color',
    'settings'  => 'hd1_menu_highlight',
    'label'     => esc_attr__( 'Highlight menu color', 'goto' ),
    'section'   => 'header_1',
    'transport' => 'auto',
    'default'   => '#ec5849',
    'output'    => array(
        array(
            'element' => array(
                '.header-layout-1 .theme-primary-menu li.current-menu-item > a',
                '.header-layout-1 .theme-primary-menu > li.current-menu-ancestor > a',
                '.header-layout-1 .theme-primary-menu > li.current-menu-parent > a',
                '.header-layout-1 .theme-primary-menu > li.current_page_parent > a',
                '.header-layout-1 .theme-primary-menu > li.current_page_ancestor > a',
                '.header-layout-1 .theme-primary-menu > li > a:hover',
                '.header-layout-1 .theme-primary-menu > li:hover > a',
                '.header-layout-1 .theme-primary-menu li ul a:hover',
                '.header-layout-1 .theme-primary-menu > li:not(.menu-item-has-mega-menu) ul a:hover',
                '.header-layout-1 .theme-primary-menu .mega-menu-row .sub-menu a:hover',
                '.header-layout-1 #theme-search-btn:hover'
            ),
            'property' => 'color',
        ),
    )
));

/*label*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'custom',
    'settings' => 'label_hd1_menu',
    'default'  => goto_label( esc_attr__( 'Menu font', 'goto' ) ),
    'section'  => 'header_1',
));

/*parent-menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'typography',
    'settings'  => 'hd1_parent_menu',
    'label'     => esc_attr__( 'Parent menu', 'goto' ),
    'section'   => 'header_1',
    'transport' => 'auto',
    'default'   => array(
        'font-family'    => 'Montserrat',
        'variant'        => 'regular',
        'font-size'      => '14px',
        'letter-spacing' => '0',
        'text-transform' => 'none',
        'color'          => '#333'
    ),
    'output'      => array(
        array(
            'element' => array(
                '.header-layout-1 .theme-primary-menu > li > a',
                '.header-layout-1 #theme-search-btn'
            ),
            'media_query' => '@media ( min-width: 992px )'
        ),
    )
));

/*sub-menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'typography',
    'settings'  => 'hd1_submenu',
    'label'     => esc_attr__( 'Submenu', 'goto' ),
    'section'   => 'header_1',
    'transport' => 'auto',
    'default'   => array(
        'font-family'    => 'Montserrat',
        'variant'        => 'regular',
        'font-size'      => '13px',
        'letter-spacing' => '0',
        'text-transform' => 'none',
        'color'          => '#333'
    ),
    'output'      => array(
        array(
            'element' => array(
                '.header-layout-1 .theme-primary-menu .sub-menu a',
            ),
            'media_query' => '@media ( min-width: 992px )'
        ),
    )
));


/* HEADER LAYOUT 2
***************************************************/

/*background menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'color',
    'settings'  => 'c_menu2_bg',
    'section'   => 'header_2',
    'label'     => esc_attr__( 'Menu background', 'goto' ),
    'transport' => 'auto',
    'default'   => 'rgba(255, 255, 255, 0)',
    'choices'   => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'     => '.header-layout-2 .header-box',
            'property'    => 'background-color',
            'media_query' => '@media ( min-width: 992px )'
        )
    ),
    'partial_refresh' => array(
        'hd2_edit_location' => array(
            'selector'        => '#hd2-edit-location',
            'render_callback' => 'goto_edit_location',
        ),
    ),
));

/*custom logo*/
Goto_Kirki::add_field( 'goto', array(
    'type'            => 'upload',
    'settings'        => 'hd2_logo',
    'section'         => 'header_2',
    'label'           => esc_attr__( 'Custom logo', 'goto' ),
    'partial_refresh' => array(
        'hd2_custom_logo' => array(
            'selector'        => '#hd2-logo',
            'render_callback' => 'goto_logo_image',
        ),
    ),
));

Goto_Kirki::add_field( 'goto', array(
    'type'            => 'upload',
    'settings'        => 'hd2_logo_mobile',
    'section'         => 'header_2',
    'label'           => esc_attr__( 'Custom logo for mobile', 'goto' ),
));

/*highlight menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'color',
    'settings'  => 'hd2_menu_highlight',
    'label'     => esc_attr__( 'Highlight color', 'goto' ),
    'section'   => 'header_2',
    'transport' => 'auto',
    'default'   => '#ec5849',
    'output'    => array(
        array(
            'element' => array(
                '.header-layout-2 .theme-primary-menu li.current-menu-item > a',
                '.header-layout-2 .theme-primary-menu > li.current-menu-ancestor > a',
                '.header-layout-2 .theme-primary-menu > li.current-menu-parent > a',
                '.header-layout-2 .theme-primary-menu > li.current_page_parent > a',
                '.header-layout-2 .theme-primary-menu > li.current_page_ancestor > a',
                '.header-layout-2 .theme-primary-menu > li > a:hover',
                '.header-layout-2 .theme-primary-menu > li:hover > a',
                '.header-layout-2 .theme-primary-menu li ul a:hover',
                '.header-layout-2 .theme-primary-menu > li:not(.menu-item-has-mega-menu) ul a:hover',
                '.header-layout-2 .theme-primary-menu .mega-menu-row .sub-menu a:hover',
                '.header-layout-2 #theme-search-btn:hover'
            ),
            'property'    => 'color',
        ),
    )
));

/*label*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'custom',
    'settings' => 'label_hd2_menu',
    'default'  => goto_label( esc_attr__( 'Menu font', 'goto' ) ),
    'section'  => 'header_2',
));

/*parent-menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'typography',
    'settings'  => 'hd2_parent_menu',
    'label'     => esc_attr__( 'Parent menu', 'goto' ),
    'section'   => 'header_2',
    'transport' => 'auto',
    'default'   => array(
        'font-family'    => 'Montserrat',
        'variant'        => 'regular',
        'font-size'      => '14px',
        'letter-spacing' => '0',
        'text-transform' => 'none',
        'color'          => '#fff'
    ),
    'output'      => array(
        array(
            'element' => array(
                '.header-layout-2 .theme-primary-menu > li > a',
                '.header-layout-2 #theme-search-btn'
            ),
            'media_query' => '@media ( min-width: 992px )'
        ),
    )
));

/*sub-menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'typography',
    'settings'  => 'hd2_submenu',
    'label'     => esc_attr__( 'Submenu', 'goto' ),
    'section'   => 'header_2',
    'transport' => 'auto',
    'default'   => array(
        'font-family'    => 'Montserrat',
        'variant'        => 'regular',
        'font-size'      => '13px',
        'letter-spacing' => '0',
        'text-transform' => 'none',
        'color'          => '#333'
    ),
    'output'      => array(
        array(
            'element' => array(
                '.header-layout-2 .theme-primary-menu .sub-menu a',
            ),
            'media_query' => '@media ( min-width: 992px )'
        ),
    )
));




/* HEADER LAYOUT 3
***************************************************/

/* wp_nav_menu data */
$nav_menu = get_terms( 'nav_menu' );
$menu_id = array( 'default' => esc_attr__( 'Default', 'goto' ) );

foreach( $nav_menu as $k ){
    $menu_id[$k->term_id] = $k->name;
}

/*background menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'color',
    'settings'  => 'c_menu3_bg',
    'section'   => 'header_3',
    'label'     => esc_attr__( 'Menu background', 'goto' ),
    'transport' => 'auto',
    'default'   => '#0000',
    'choices'   => array(
        'alpha' => true,
    ),
    'output' => array(
        array(
            'element'     => '.header-layout-3 .header-box',
            'property'    => 'background-color',
            'media_query' => '@media ( min-width: 992px )'
        )
    ),
    'partial_refresh' => array(
        'hd3_edit_location' => array(
            'selector'        => '#hd3-edit-location',
            'render_callback' => 'goto_edit_location',
        ),
    ),
));

/*telephone number*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'text',
    'settings'  => 'c_menu3_tel',
    'section'   => 'header_3',
    'label'     => esc_attr__( 'Telephone number', 'goto' ),
    'transport' => 'postMessage',
    'js_vars'   => array(
        array(
            'element'  => '.header-layout-3 .tel-number',
            'function' => 'html',
        ),
    ),
    'default' => '+1 800 311 3006',
));

/*highlight color*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'color',
    'settings'  => 'hd3_highlight',
    'label' => esc_attr__( 'Hightlight menu color', 'goto' ),
    'section'   => 'header_3',
    'default' => '#ec5849',
    'transport' => 'auto',
    'output' => array(
        array(
            'element' => array(
                '.header-layout-3 .theme-primary-menu li.current-menu-item > a',
                '.header-layout-3 .theme-primary-menu > li.current-menu-ancestor > a',
                '.header-layout-3 .theme-primary-menu > li.current-menu-parent > a',
                '.header-layout-3 .theme-primary-menu > li.current_page_parent > a',
                '.header-layout-3 .theme-primary-menu > li.current_page_ancestor > a',
                '.header-layout-3 .theme-primary-menu > li > a:hover',
                '.header-layout-3 .theme-primary-menu > li:hover > a',
                '.header-layout-3 .theme-primary-menu li ul a:hover',
                '.header-layout-3 .theme-primary-menu > li:not(.menu-item-has-mega-menu) ul a:hover',
                '.header-layout-3 .theme-primary-menu .mega-menu-row .sub-menu a:hover'
            ),
            'property' => 'color',
        )
    )
));

/*custom menu for header layout 3*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'select',
    'settings' => 'hd3_menu_id',
    'label'    => esc_attr__( 'Nav menu', 'goto' ),
    'section'  => 'header_3',
    'default'  => 'default',
    'choices'  => $menu_id
));

/*label*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'custom',
    'settings' => 'label_hd3_menu',
    'default'  => goto_label( esc_attr__( 'Menu font', 'goto' ) ),
    'section'  => 'header_3',
));

/*parent-menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'typography',
    'settings'  => 'hd3_parent_menu',
    'label'     => esc_attr__( 'Parent menu', 'goto' ),
    'section'   => 'header_3',
    'transport' => 'auto',
    'default'   => array(
        'font-family'    => 'Montserrat',
        'variant'        => 600,
        'font-size'      => '14px',
        'letter-spacing' => '0',
        'text-transform' => 'none',
        'color'          => '#333'
    ),
    'output'      => array(
        array(
            'element' => array(
                '.header-layout-3 .theme-primary-menu > li > a',
                '.header-layout-3 .search-btn',
                '.header-layout-3 .tel-number'
            ),
            'media_query' => '@media ( min-width: 992px )'
        ),
    )
));

/*sub-menu*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'typography',
    'settings'  => 'hd3_submenu',
    'label'     => esc_attr__( 'Submenu', 'goto' ),
    'section'   => 'header_3',
    'transport' => 'auto',
    'default'   => array(
        'font-family'    => 'Montserrat',
        'variant'        => 600,
        'font-size'      => '13px',
        'letter-spacing' => '0',
        'text-transform' => 'none',
        'color'          => '#8f8f8f'
    ),
    'output'      => array(
        array(
            'element' => array(
                '.header-layout-3 .theme-primary-menu .sub-menu a',
            ),
            'media_query' => '@media ( min-width: 992px )'
        ),
    )
));