<?php

/* ADD PAGE HEADER SECTION
***************************************************/
Goto_Kirki::add_section( 'page_header', array(
    'title'    => esc_attr__( 'Page Header', 'goto'),
    'icon'     => 'ion-navicon-round',
    'priority' => 1,
));



/*label*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'custom',
    'settings' => 'c_header_label',
    'section'  => 'page_header',
    'default'  => goto_label( esc_attr__( 'Custom your page header here', 'goto' ) ),
));

/*Show page header*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'switch',
    'settings' => 'c_header',
    'label'    => esc_attr__( 'Show page header', 'goto' ),
    'section'  => 'page_header',
    'default'  => true,
    'choices'  => array(
        'on'  => esc_attr__('Yes', 'goto'),
        'off' => esc_attr__('No', 'goto'),
	),
    'partial_refresh' => array(
        'theme_page_header' => array(
            'selector'        => '#theme-page-header',
            'render_callback' => 'goto_page_header',
        ),
    ),
));

/*Show breadcrumbs*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'switch',
    'settings' => 'c_navigation',
    'section'  => 'page_header',
    'label'    => esc_attr__( 'Show breadcrumbs', 'goto' ),
    'default'  => true,
    'choices'  => array(
		'on'  => esc_attr__( 'Yes', 'goto' ),
		'off' => esc_attr__( 'No', 'goto' )
	),
	'active_callback'  => array(
		array(
			'setting'  => 'c_header',
			'operator' => '==',
			'value'    => true,
		),
	),
    'partial_refresh' => array(
        'theme_bread' => array(
            'selector'        => '#theme-bread',
            'render_callback' => 'goto_theme_breadcrumbs',
        ),
    ),
));

/*text color*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'color',
    'settings'  => 'p_color',
    'label'     => esc_attr__( 'Text Color', 'goto' ),
    'section'   => 'page_header',
    'default'   => '#ffffff',
    'transport' => 'auto',
    'output'    => array(
        array(
            'element'  => '.page-title, .crums-item, .crums-item span',
            'property' => 'color',
        )
    ),
    'active_callback'  => array(
        array(
            'setting'  => 'c_header',
            'operator' => '==',
            'value'    => true,
        ),
    )
));

/*space*/
Goto_Kirki::add_field( 'goto', array(
    'type'        => 'dimensions',
    'settings'    => 'p_space',
    'label'       => esc_attr__( 'Space', 'goto' ),
    'section'     => 'page_header',
    'default'     => array(
        'height'        => '380px',
        'margin-bottom' => '70px',
    ),
    'transport' => 'auto',
    'output'    => array(
        array(
            'element'  => '.page-header',
            'property' => 'height',
            'choice'   => 'height'
        ),
        array(
            'element'  => '.page-header',
            'property' => 'margin-bottom',
            'choice'   => 'margin-bottom'
        ),
    ),
    'active_callback'  => array(
        array(
            'setting'  => 'c_header',
            'operator' => '==',
            'value'    => true,
        ),
    )
));

/*vertical align*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'radio-buttonset',
    'settings'  => 'p_vertical_align',
    'label'     => esc_attr__( 'Vertical align', 'goto' ),
    'section'   => 'page_header',
    'default'   => 'center',
    'transport' => 'auto',
    'choices'   => array(
        'flex-start' => esc_attr__( 'Top', 'goto' ),
        'center'     => esc_attr__( 'Middle', 'goto' ),
        'flex-end'   => esc_attr__( 'Bottom', 'goto' ),
    ),
    'output'     => array(
        array(
            'element'  => '.page-header .container',
            'property' => 'justify-content'
        )
    ),
    'active_callback'  => array(
        array(
            'setting'  => 'c_header',
            'operator' => '==',
            'value'    => true,
        ),
    )
));

/*horizontal align*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'radio-buttonset',
    'settings'  => 'p_horizontal_align',
    'label'     => esc_attr__( 'Horizontal align', 'goto' ),
    'section'   => 'page_header',
    'default'   => 'center',
    'transport' => 'auto',
    'choices'   => array(
        'flex-start' => esc_attr__( 'Left', 'goto' ),
        'center'     => esc_attr__( 'Center', 'goto' ),
        'flex-end'   => esc_attr__( 'Right', 'goto' ),
    ),
    'output'     => array(
        array(
            'element'  => '.page-header .container',
            'property' => 'align-items'
        )
    ),
    'active_callback'  => array(
        array(
            'setting'  => 'c_header',
            'operator' => '==',
            'value'    => true,
        ),
    )
));

/*background*/
Goto_Kirki::add_field( 'goto', array(
    'type'      => 'background',
    'settings'  => 'c_header_bg',
    'section'   => 'page_header',
    'transport' => 'auto',
    'default'   => array(
        'background-color'      => '#222',
        'background-image'      => '',
        'background-repeat'     => 'no-repeat',
        'background-position'   => 'center center',
        'background-size'       => 'cover',
        'background-attachment' => 'scroll',
    ),
    'output' => array(
        array(
            'element' => '.page-header'
        )
    ),
    'active_callback'  => array(
        array(
            'setting'  => 'c_header',
            'operator' => '==',
            'value'    => true,
        ),
    ),
));

/*parallax background image*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'switch',
    'settings' => 'c_parallax',
    'section'  => 'page_header',
    'label'    => esc_attr__( 'Background parallax', 'goto' ),
    'default'  => true,
    'choices'  => array(
        'on'  => esc_attr__( 'Yes', 'goto' ),
        'off' => esc_attr__( 'No', 'goto' )
    ),
    'active_callback'  => array(
        array(
            'setting'  => 'c_header',
            'operator' => '==',
            'value'    => true,
        ),
    ),
));

/*background parallax speed*/
Goto_Kirki::add_field( 'goto', array(
    'type'     => 'number',
    'settings' => 'c_parallax_speed',
    'section'  => 'page_header',
    'label'    => esc_attr__( 'Parallax speed', 'goto' ),
    'default'  => 3,
    'choices'  => array(
        'min'  => 1,
        'max'  => 50,
        'step' => 1,
    ),
    'active_callback'  => array(
        array(
            'setting'  => 'c_header',
            'operator' => '==',
            'value'    => true,
        ),
        array(
            'setting'  => 'c_parallax',
            'operator' => '==',
            'value'    => true,
        ),
    ),
));