<?php

if ( ! defined( 'ABSPATH' ) ) die( 'Direct access forbidden.' );

echo wp_kses_post( $before_widget );
echo wp_kses_post( $title );

?>
    <div class="widget flickr-widget flickr-col-<?php echo esc_attr( $col ); ?>">
        <?php
            $rss = fetch_feed('https://api.flickr.com/services/feeds/photos_public.gne?ids='. $flickr_id. '&lang=en-us&format=rss_200');

            if ( is_wp_error( $rss ) ) return esc_html_e( 'Something went wrong!!', 'goto' );

            $max_items = $rss->get_item_quantity( absint( $number ) );
            $items = $rss->get_items( 0, $max_items );

            if ( $max_items == 0 ):
            ?>
                <span><?php esc_html_e( 'No items found!', 'goto' ); ?></span>
            <?php
            else :
                $_img_src = '';
                foreach ( $items as $key ):
                    $image_group = $key->get_item_tags( 'http://search.yahoo.com/mrss/', 'thumbnail' );
                    $image_attrs = $image_group[0]['attribs'];

                    foreach( $image_attrs as $image ):
                        $baseurl    = str_replace( '_s.jpg', '', $image['url'] );
                        switch( $size ){
                            case 'small':
                                $_img_src = $baseurl . "_m.jpg";
                                break;
                            case 'square':
                                $_img_src = $baseurl . "_s.jpg";
                                break;
                            case 'large_square':
                                $_img_src = $baseurl . "_q.jpg";
                                break;
                            case 'thumbnail':
                                $_img_src = $baseurl . "_t.jpg";
                                break;
                            case 'medium':
                                $_img_src = $baseurl . ".jpg";
                                break;
                            case 'large':
                                $_img_src = $baseurl . "_b.jpg";
                                break;
                            case 'full':
                                $_img_src = $baseurl . "_o.jpg";
                                break;
                        }

                        echo sprintf(
                            '<a target="_blank" href="%1$s"><img src="%2$s" alt="%3$s"></a>',
                            esc_url( $key->get_permalink() ),
                            esc_url( $_img_src ),
                            esc_attr( $key->get_title() )
                        );
                    endforeach;
                endforeach;
            endif;
            ?>
    </div>

<?php
echo wp_kses_post( $after_widget );