<?php
// @codingStandardsIgnoreStart

/* LEFT CONTENT OPTIONS
***************************************************/
$tour_id      = get_the_ID();
$tour_title   = get_the_title();
$style        = goto_tour_header();
$gallery      = fw_get_db_post_option( get_the_ID(), 'gallery' );

/*price*/
$price        = fw_get_db_post_option( get_the_ID(), 'price' );
$sale_price   = fw_get_db_post_option( get_the_ID(), 'sale_price' );

$sale         = ! empty( $price ) && is_numeric( $sale_price ) ? round( ( ( $price - $sale_price ) / $price ) * 100, 1 ) : 0;

/*short infomation*/
$days         = fw_get_db_post_option( get_the_ID(), 'days' );
$date         = fw_get_db_post_option( get_the_ID(), 'date' );
// Start time, this override for `$start_date`.
$start_time   = fw_get_db_post_option( get_the_ID(), 'start_time' );
$availability = fw_get_db_post_option( get_the_ID(), 'avaibility' );
$age          = fw_get_db_post_option( get_the_ID(), 'age' );

/*itinerary*/
$pdf          = fw_get_db_post_option( get_the_ID(), 'pdf' );
$detail       = fw_get_db_post_option( get_the_ID(), 'detail' );

/*map*/
$map          = fw_get_db_post_option( get_the_ID(), 'tour_map' );

/* RIGHT SIDEBAR OPTIONS
***************************************************/
if ( function_exists( 'fw_get_db_ext_settings_option' ) ) {
	$general_booking_type_setting = fw_get_db_ext_settings_option( 'tour', 'tour_booking_type' );
	$single_booking_type_setting  = fw_get_db_post_option( get_the_ID(), 'tour_booking_type' );
}
$unit        = function_exists( 'fw_get_db_ext_settings_option' ) ? goto_unit( fw_get_db_ext_settings_option( 'tour', 'unit' ) ) : '&#36;';
$symbol_post =  ( function_exists( 'fw_get_db_ext_settings_option' ) && fw_get_db_ext_settings_option( 'tour', 'symbol-pos' ) ) ? fw_get_db_ext_settings_option( 'tour', 'symbol-pos' )  : 'left';
?>


<?php /*MAIN CONTAINER*/ ?>
<div class="container">
    <div id="has-sidebar-sticky">
        <?php /*LEFT CONTENT*/ ?>
        <div class="tour-left-content">
            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php goto_schema_markup( 'blog_list' ); ?>>
                <?php /*GALLERY CAROUSEL*/
                    if( 'tour-2' == $style && ! empty( $gallery ) ):
                        /*TINY SLIDER*/
                        wp_enqueue_style( 'tiny-slider' );
                        wp_enqueue_script( 'tiny-slider-js' );
                        
                        wp_add_inline_script(
                            'tiny-slider-js',
                            "window.addEventListener( 'load', function(){
                                var slider = tns({
                                    container: '.tour-gallery-slide',
                                    loop: false,
                                    items: 1,
                                    autoHeight: true,
                                    mouseDrag: true,
                                    nav: true,
                                    controls: false,
                                    arrowKeys: true,
                                    responsive: {
                                        768: {
                                            controls: true,
                                            nav: false
                                        }
                                    }
                                });
                            } );",
                            'after'
                        );

                        /*PHOTOSWIPE LIGHTBOX*/
                        wp_enqueue_style( 'pswp-lightbox' );
                        wp_enqueue_script( 'jquery-pswp-global' );
                        wp_add_inline_script(
                            'jquery-pswp-global',
                            "document.addEventListener( 'DOMContentLoaded', function () {
                                jQuery( '.tour-gallery' ).photoSwipe( 'a', {
                                    bgOpacity: 0.9,
                                    shareEl: false
                                });
                            });",
                            'after'
                        );

                    ?>
                    <div class="tour-gallery">
                        <div class="tour-gallery-slide">
                            <?php
                                foreach( $gallery as $key ):
                                    $img_large = wp_get_attachment_image_url( $key['attachment_id'], 'large' );
                                    $img_alt = goto_img_alt( $key['attachment_id'], esc_attr__( 'Tour gallery image', 'goto' ) );
                                ?>
                                <a href="<?php echo esc_url( $key['url'] ); ?>">
                                    <img src="<?php echo esc_url( $img_large ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php /*SHORT INFORMATION*/ ?>
                <div class="tour-desc">
                    <?php if( ! empty( $days ) ): ?>
                        <div class="tour-desc-item">
                        	<?php echo apply_filters( 'goto_tour_clock_icon', '<span class="tour-desc-icon goto-icon-clock"></span>' ); ?>
                            <div class="tour-desc-text">
                                <?php
                                    if( $days < 2 ){
                                        echo esc_html( $days ) . ' ' . esc_html__( 'day', 'goto' );
                                    }else{
                                        echo esc_html( $days ) . ' ' . esc_html__( 'days', 'goto' );
                                    }
                                ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if( ! empty( $date ) || ! empty( $start_time ) ): ?>
                        <div class="tour-desc-item">
                            <?php echo apply_filters( 'goto_tour_calendar_icon', '<span class="tour-desc-icon goto-icon-calendar-2"></span>' ); ?>
                            <div class="tour-desc-text">
                            	<?php
                            		if ( ! empty( $start_time ) ) {
                            			echo esc_html( $start_time );
                            		} else {
                            			echo date_i18n( get_option( 'date_format' ), strtotime( $date ) );
                            		}
                            	?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if( ! empty( $availability ) ): ?>
                        <div class="tour-desc-item">
                            <?php echo apply_filters( 'goto_tour_group_icon', '<span class="tour-desc-icon goto-icon-group"></span>' ); ?>
                            <div class="tour-desc-text">
                                <?php echo esc_html__( 'Availability: ', 'goto' ) . esc_html( $availability ); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php do_action( 'goto_tour_desc_before_last_item' ); ?>

                    <?php if( ! empty( $age ) ): ?>
                        <div class="tour-desc-item">
                            <?php echo apply_filters( 'goto_tour_user_icon', '<span class="tour-desc-icon goto-icon-user-2"></span>' ); ?>
                            <div class="tour-desc-text">
                                <?php echo esc_html__( 'Age: ', 'goto' ) . esc_html( $age ); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>

                <div class="entry-summary"><?php goto_seo_data(); ?></div>

                <div class="entry-content" <?php goto_schema_markup( 'post_content' ); ?>>

                    <?php /*MAIN INFOR SECTION*/ ?>
                    <div id="tour-link-info" class="tour-section">
                        <h5 class="tour-section-title"><?php esc_html_e( 'Main Info', 'goto' ); ?></h5>
                        <?php
                            the_content();
                            goto_wp_link_pages();
                        ?>
                    </div>                    

                    <?php /*ITINERARY SECTION*/ ?>
                    <?php if( ! empty( $pdf ) || ! empty( $detail ) ): ?>
                        <div id="tour-link-itinerary" class="tour-section">
                            <h5 class="tour-section-title"><?php esc_html_e( 'Itinerary', 'goto' ); ?></h5>

                            <?php if( ! empty( $pdf ) ): /*file download button*/ ?>
                                <a class="tour-download-btn" href="<?php echo esc_url( $pdf['url'] ); ?>" target="_blank"><?php esc_html_e( 'Download Brochure', 'goto' ); ?></a>
                            <?php
                                endif;

                                do_action( 'goto_tour_after_itinerary_download_button' );

                                /*ACCORDION DETAIL*/
                                if( ! empty( $detail ) ):
                            ?>
                                <div class="tour-accordion">
                                    <?php
                                        foreach( $detail as $kk => $key ){
                                        ?>
                                        <div class="tour-acc-item">
                                            <strong class="tour-acc-head"><?php echo esc_html( $key['title'] ); ?></strong>
                                            <div class="tour-acc-content">
                                                <?php
                                                    if( ! empty( $key['thumb'] ) ):
                                                    $img_alt = goto_img_alt( $key['thumb']['attachment_id'], esc_attr__( 'Tour image', 'goto' ) );
                                                    ?>
                                                    <img class="tour-acc-img" src="<?php echo esc_url( $key['thumb']['url'] ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
                                                <?php endif; ?>
                                                <div class="tour-acc-text"><?php echo ( $key['content'] ); ?></div>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>

                                <?php
                                    wp_add_inline_script(
                                        'goto-custom-script',
                                        "jQuery( document.body ).on( 'click', '.tour-acc-head', function( e ) {

											e.preventDefault();

											var parent    = jQuery( '.tour-accordion' ),
												t         = jQuery( this ),
												next      = t.next(),
												nextAlias = parent.find( '.tour-acc-content' ),
												head      = parent.find( '.tour-acc-head' );

											if ( next.hasClass( 'show' ) ) {
												next.slideUp( 300, function() {
													jQuery( this ).removeClass( 'show' );
												} );
												t.removeClass( 'active' );
											} else {
												head.removeClass( 'active' );
												nextAlias.not( this ).slideUp( 300, function() {
													jQuery( this ).removeClass( 'show' );
												} );
												next.slideDown( 300, function() {
													jQuery( this ).addClass( 'show' );
												} );
												t.addClass( 'active' );
											}
										});",
                                        'after'
                                    );
                                endif;
                            ?>
                        </div>
                    <?php endif; ?>
                    

                    <?php /*MAP SECTION*/ ?>
                    <?php if( ! empty( $map ) ): ?>
                        <div id="tour-link-map" class="tour-section">
                            <h5 class="tour-section-title"><?php esc_html_e( 'Maps', 'goto' ); ?></h5>
                            <?php echo ( $map ); ?>
                        </div>
                    <?php endif; ?>
                    

                    <?php /*REVIEWS SECTION*/ ?>
                    <?php if ( defined( 'FW' ) && function_exists( 'fw_ext_feedback' ) ) { ?>
	                    <div id="tour-link-reviews" class="tour-section">
	                        <?php
	                            if ( comments_open() || get_comments_number() ):
	                                comments_template();
	                            endif;
	                        ?>
	                    </div>
	                <?php } ?>
                </div>
            </article>
        </div>
        
        <?php /*RIGHT SIDEBAR*/ ?>
        <div class="tour-right-sidebar" id="tour-sidebar-sticky">
            <div class="tour-sidebar js-booking-tour">
                <?php if( ! empty( $price ) ): ?>
                    <div class="tour-price-box">
                        <?php if( 0 != $sale_price && is_numeric( $sale_price ) ): ?>
                            <span class="tour-sale-rate"><span>-<?php echo esc_html( $sale ); ?>%</span></span>
                        <?php endif; ?>
                        <span class="tour-price">
                            <?php
                            	$_regular_price = '<span class="tour-regu-price">'. goto_price_unit( $symbol_post, $unit, $price, false ) .'</span>';
								$_sale_price    = 0 != $sale_price ? '<span class="tour-sale-price">'. goto_price_unit( $symbol_post, $unit, $sale_price, false ) .'</span>' : '';

                                printf(
                                    esc_html_x( 'From: %1$s %2$s', '%1$s: Regular price, %2$s: Sale price','goto' ),
                                    $_regular_price,
                                    $_sale_price
                                );
                            ?>
                        </span>
                    </div>
                <?php endif; ?>

	            <div class="tour-book-form">
		            <?php
		            if ( function_exists( 'fw_get_db_ext_settings_option' ) ) {

			            /**
			             * Check the single booking type setting
			             *  If the value is 'Default'
			             *    Get the general booking type setting from Tours -> Settings -> Choose Tour Booking Type
			             *    Render booking form based on the general booking type setting is 'Contact Form 7' or 'WooCommerce'
			             *  Else render booking form based on the single booking type setting
			             */

		            	if ( 'default' === $single_booking_type_setting['picked'] ) {
				            if ( 'contact' === $general_booking_type_setting['picked'] ) {
					            $ctf_id     = $general_booking_type_setting['contact']['ctf7'];
					            echo do_shortcode( '[contact-form-7 id="'. esc_attr( $ctf_id ) .'"]' );
                            } elseif( 'shortcode' == $general_booking_type_setting['picked'] ){
                                $shortcode     = $general_booking_type_setting['shortcode']['shortcode'];
                                echo do_shortcode($shortcode);
                            } 
                            else {
					            goto_booking_form( $tour_id, $tour_title, $unit, $price, $sale_price );
				            }
			            } elseif ( 'contact' === $single_booking_type_setting['picked'] ) {
				            $ctf_id     = $single_booking_type_setting['contact']['ctf7'];
				            echo do_shortcode( '[contact-form-7 id="'. esc_attr( $ctf_id ) .'"]' );
                        } elseif( 'shortcode' == $single_booking_type_setting['picked'] ){
                            $shortcode     = $single_booking_type_setting['shortcode']['shortcode'];
                            echo do_shortcode($shortcode);
                        } 
                        else {
				            goto_booking_form( $tour_id, $tour_title, $unit, $price, $sale_price );
			            }

			            goto_date_picker( '.tour-date-picker' );
		            }
		            ?>
	            </div>
                
                <div class="tour-custumer-support"><?php
                    if( ! empty( get_theme_mod( 'support', '' ) ) ){
                        echo get_theme_mod( 'support', '' );
                    }
                ?></div>
            </div>
        </div>
    </div>

    <?php /*TOUR RELATED*/ ?>
    <?php
        $number = intval( get_theme_mod( 'tour_related', 3 ) );

        if( 0 !== $number ):
            get_template_part( 'template-parts/tour', 'related' );
        endif;
    ?>
</div>