<?php

$number   = intval( get_theme_mod( 'tour_related', 3 ) );
$col      = intval( get_theme_mod( 'tour_related_col', 3 ) );
$carousel = get_theme_mod( 'tour_related_carousel', false );

$cat_terms    = get_the_terms( get_queried_object_id(), 'ht_tour_cat' );
if ( ! $cat_terms ) {
	return;
}
$cat_term_ids = wp_list_pluck( $cat_terms, 'term_id' );

$args = array(
	'post_type'      => 'ht_tour',
	'posts_per_page' => $number,
	'post__not_in'   => array( get_queried_object_id() ),
	'post_status'    => 'publish',
	'tax_query' => array(
		array(
			'taxonomy' => 'ht_tour_cat',
			'field'    => 'id',
			'terms'    => $cat_term_ids,
			'operator' => 'IN',
		),
	),
);

$id = 'tour-related-box';

$rt = new WP_Query( $args );

if( $rt->have_posts() ):

	if( true == $carousel ){
		$id = 'tour-related-slider';

		wp_enqueue_style( 'tiny-slider' );
		wp_enqueue_script( 'tiny-slider-js' );

		wp_add_inline_script(
			'tiny-slider-js',
			"window.addEventListener( 'load', function(){
				var slider = tns({
					container: '#tour-related-slider',
					loop: false,
					items: 1,
					autoHeight: true,
					mouseDrag: true,
					nav: false,
					gutter: 30,
					controls: false,
					responsive: {
						240: {
							items: 1
						},
						768: {
							items: 2
						},
						992: {
							items: {$col},
							controls: true
						}
					}
				});
			} );",
			'after'
		);
	}
?>

<div class="tour-related">
	<h2><?php esc_html_e( 'Similar Tour', 'goto' ); ?></h2>
	<div id="<?php echo esc_attr( $id ); ?>" class="tour-related-section ht-grid ht-grid-<?php echo esc_attr( $col ); ?> ht-grid-tablet-2 ht-grid-mobile-1">
		<?php
			while ( $rt->have_posts() ) :
				$rt->the_post();

				/*OPTIONS*/

				/*price*/
				$price      = fw_get_db_post_option( get_the_ID(), 'price' );
				$sale_price = fw_get_db_post_option( get_the_ID(), 'sale_price' );
				$days       = fw_get_db_post_option( get_the_ID(), 'days' );
				$unit       = goto_unit( fw_get_db_ext_settings_option( 'tour', 'unit' ) );

				/*rating*/
				$rating     = function_exists( 'fw_ext_feedback_stars_get_post_rating' ) ? fw_ext_feedback_stars_get_post_rating() : array( 'count' => 0 );

				/*thumbnail*/
				$img_id     = get_post_thumbnail_id( get_the_ID() );
				$img_alt    = goto_img_alt( $img_id, esc_attr__( 'Tour image thumbnail', 'goto' ) );
				$img_src    = ! empty( $img_id ) ? get_the_post_thumbnail_url( get_the_ID(), 'medium_large' ) : get_template_directory_uri() . '/images/tour/370x240.png';

				/*term list*/
				$terms      = get_the_term_list( get_the_ID(), 'ht_tour_cat', null, ', ', null );
			?>
				<div class="tour-related-item ht-grid-item">
					<div class="tour-related-item-wr">
						<a class="tour-related-item-head" href="<?php the_permalink(); ?>">
							<img src="<?php echo esc_url( $img_src ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
							<?php if ( ! empty( $price ) ) : ?>
								<span class="trh-price-box">
									<span class="trh-price"><?php echo esc_html( $unit . number_format( $price ) ); ?></span>
									<?php if ( ! empty( $sale_price ) ) : ?>
										<span class="trh-sale-price"><?php echo esc_html( $unit . number_format( $sale_price ) ); ?></span>
									<?php endif; ?>
								</span>
							<?php endif; ?>
						</a>
						
						<div class="tour-related-item-sum">
							<h3 class="trs-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
							<?php
							if ( $terms ) :
								echo '<span class="trs-terms">' . $terms . '</span>';
							endif;
							?>

							<div class="trs-reviews">
								<?php if ( isset( $rating['average'] ) && $rating['average'] ) : ?>
									<span class="tour-average"><?php echo esc_html( round( $rating['average'], 1 ) ); ?></span>
								<?php endif; ?>

								<span class="tour-review-count">
									<?php
										printf(
											_nx(
												'1 review',
												'%1s review(s)',
												number_format_i18n( $rating['count'] ),
												'review count',
												'goto'
											),
											number_format_i18n( $rating['count'] )
										);
									?>
								</span>

								<span class="related-days">
									<span class="goto-icon-clock"></span>
									<?php
										printf(
											_nx(
												'1 day',
												'%1$s days',
												$days,
												'day of the week',
												'goto'
											),
											$days
										);
									?>
								</span>
							</div>
						</div>
					</div>
				</div>
			<?php endwhile; wp_reset_postdata(); ?>
	</div>
</div>

<?php
	endif;